
#ifndef _FCON_
#define _FCON_

/* DO NOT EDIT: generated by rp2gen from fcon.rpc2 */
#ifdef __cplusplus
extern "C" {
#endif
#include <rpc2/rpc2.h>
#include <rpc2/se.h>
#include <rpc2/errors.h>
#ifdef __cplusplus
}
#endif

 /* BLURB gpl

                           Coda File System
                              Release 5

          Copyright (c) 1987-1999 Carnegie Mellon University
                  Additional copyrights listed below

This  code  is  distributed "AS IS" without warranty of any kind under
the terms of the GNU General Public Licence Version 2, as shown in the
file  LICENSE.  The  technical and financial  contributors to Coda are
listed in the file CREDITS.

                        Additional copyrights
                           none currently

#*/

#define FCONSUBSYSID	7146

typedef struct FailFilter {
    RPC2_Integer ip1;
    RPC2_Integer ip2;
    RPC2_Integer ip3;
    RPC2_Integer ip4;
    RPC2_Integer color;
    RPC2_Integer id;
    RPC2_Integer lenmin;
    RPC2_Integer lenmax;
    RPC2_Integer factor;
    RPC2_Integer speed;
    RPC2_Integer latency;
} FailFilter;

typedef enum{ sendSide=0, recvSide=1, noSide=2 } FailFilterSide;

#define Fcon_HEAD_VERSION	1126729718

#ifndef _STUB_PREDEFINED_
#define _STUB_PREDEFINED_

typedef struct CallCountEntry {
    RPC2_String name;
    RPC2_Integer countent;
    RPC2_Integer countexit;
    RPC2_Integer tsec;
    RPC2_Integer tusec;
    RPC2_Integer counttime;
} CallCountEntry;

typedef struct MultiCallEntry {
    RPC2_String name;
    RPC2_Integer countent;
    RPC2_Integer countexit;
    RPC2_Integer tsec;
    RPC2_Integer tusec;
    RPC2_Integer counttime;
    RPC2_Integer counthost;
} MultiCallEntry;

typedef struct MultiStubWork {
    RPC2_Integer opengate;
    RPC2_Integer tsec;
    RPC2_Integer tusec;
} MultiStubWork;
#endif /* _STUB_PREDEFINED_ */

/* Op codes and definitions */

#ifdef __cplusplus
extern "C"{
#endif
long Fcon_ExecuteRequest(RPC2_Handle cid, RPC2_PacketBuffer *pb, SE_Descriptor *se);

long GetInfo(RPC2_Handle cid, RPC2_BoundedBS *name);
long Fcon_GetInfo(RPC2_Handle cid, RPC2_BoundedBS *name);
#define GetInfo_OP	1
extern ARG GetInfo_ARGS[];
#define GetInfo_PTR	GetInfo_ARGS

long InsertFilter(RPC2_Handle cid, FailFilterSide side, RPC2_Integer which, FailFilter *filter);
long Fcon_InsertFilter(RPC2_Handle cid, FailFilterSide side, RPC2_Integer which, FailFilter *filter);
#define InsertFilter_OP	2
extern ARG InsertFilter_ARGS[];
#define InsertFilter_PTR	InsertFilter_ARGS

long RemoveFilter(RPC2_Handle cid, FailFilterSide side, RPC2_Integer id);
long Fcon_RemoveFilter(RPC2_Handle cid, FailFilterSide side, RPC2_Integer id);
#define RemoveFilter_OP	3
extern ARG RemoveFilter_ARGS[];
#define RemoveFilter_PTR	RemoveFilter_ARGS

long ReplaceFilter(RPC2_Handle cid, FailFilterSide side, RPC2_Integer which, FailFilter *id);
long Fcon_ReplaceFilter(RPC2_Handle cid, FailFilterSide side, RPC2_Integer which, FailFilter *id);
#define ReplaceFilter_OP	4
extern ARG ReplaceFilter_ARGS[];
#define ReplaceFilter_PTR	ReplaceFilter_ARGS

long GetFilters(RPC2_Handle cid, FailFilterSide side, RPC2_BoundedBS *filters);
long Fcon_GetFilters(RPC2_Handle cid, FailFilterSide side, RPC2_BoundedBS *filters);
#define GetFilters_OP	5
extern ARG GetFilters_ARGS[];
#define GetFilters_PTR	GetFilters_ARGS

long CountFilters(RPC2_Handle cid, FailFilterSide side);
long Fcon_CountFilters(RPC2_Handle cid, FailFilterSide side);
#define CountFilters_OP	6
extern ARG CountFilters_ARGS[];
#define CountFilters_PTR	CountFilters_ARGS

long PurgeFilters(RPC2_Handle cid, FailFilterSide side);
long Fcon_PurgeFilters(RPC2_Handle cid, FailFilterSide side);
#define PurgeFilters_OP	7
extern ARG PurgeFilters_ARGS[];
#define PurgeFilters_PTR	PurgeFilters_ARGS

#ifdef __cplusplus
}
#endif
#define FconOPARRAYSIZE 8

extern CallCountEntry Fcon_CallCount[];

extern MultiCallEntry Fcon_MultiCall[];

extern MultiStubWork Fcon_MultiStubWork[];

extern long Fcon_ElapseSwitch;

extern long Fcon_EnqueueRequest;

#endif /* _FCON_ */
