%define pkgname wold
%define version 0.2.4
%define rel 1

%define lt_version @LT_CURRENT@.@LT_REVISION@.@LT_AGE@
%define lt_release @LT_RELEASE@

%define prefix /usr
%define sysconfdir /etc
%define package_datadir %{_datarootdir}/%{pkgname}

%define __aclocal   aclocal || aclocal -I ./macros
%define configure_args  %{nil}

Summary:        Wake on LAN dispatcher
Name:           %{pkgname}
Version:        %{version}
Release:        %{rel}
Source0:        %{pkgname}-%{version}.tar.gz
License:        GPL
Group:          Network Servers
Vendor:         Lodz University of Technology
BuildRoot:      /var/tmp/%{pkgname}-%{version}.root
Requires:       libconfuse
Requires:       systemd
BuildRequires:  libconfuse-devel
BuildRequires:  automake
BuildRequires:  autoconf
BuildRequires:  gcc
%if 0%{?rhel} < 8
BuildRequires: systemd
%else
BuildRequires: systemd-rpm-macros
%{?systemd_requires}
%endif
BuildRequires:  pkgconfig(systemd)
Prefix:         %{prefix}

%define _unpackaged_files_terminate_build 0

%description
Wake on LAN dispatcher

%prep
%setup

%build
%configure %{configure_args}
# This is why we copy the CFLAGS to the CXXFLAGS in configure.in
# CFLAGS="%{optflags}" CXXFLAGS="%{optflags}" ./configure %{_target_platform} --prefix=%{prefix}
%make_build

%install
rm -rf "$RPM_BUILD_ROOT"
install -d $RPM_BUILD_ROOT%{sysconfdir}
install -d $RPM_BUILD_ROOT%{sysconfdir}/%{pkgname}
%make_install DESTDIR="$RPM_BUILD_ROOT"

%clean
rm -rf "$RPM_BUILD_ROOT"

%pre
%if 0%{?fedora}
%service_add_pre %{pkgname}.service
%endif

%post
%if 0%{?fedora}
%service_add_post %{pkgname}.service
%else
%if 0%{?rhel} >= 8
%systemd_post %{pkgname}.service
%else
%if 0%{?rhel} < 8
/bin/systemctl --system daemon-reload &> /dev/null || :
%endif
%endif
%endif

%preun
%if 0%{?fedora}
%service_del_preun %{pkgname}.service
%else
%if 0%{?rhel} >= 8
%systemd_preun %{pkgname}.service
%endif
%endif

%postun
%if 0%{?fedora}
%service_del_postun %{pkgname}.service
%else
%if 0%{?rhel} >= 8
%systemd_postun_with_restart  %{pkgname}.service
%else
%if 0%{?rhel} < 8
/bin/systemctl --system daemon-reload &> /dev/null || :
%endif
%endif
%endif

%files
%defattr(644,root,root,755)
%doc COPYING README INSTALL AUTHORS NEWS
%dir %{sysconfdir}/%{pkgname}
%config %{sysconfdir}/%{pkgname}/main.cfg
%config %{sysconfdir}/sysconfig/%{pkgname}
%{_unitdir}/%{pkgname}.service
%attr(755,root,root) %{_sbindir}/%{pkgname}
