#ifndef __VARS_H
#define __VARS_H

/*
 * Copyright (C) 2002 Bartosz Lis <bartoszl@ics.p.lodz.pl>
 * This is the main module
 */

#include <ctype.h>

typedef struct variable
{
  struct variable *next;
  char            *name;
  char            *value;
} variable_t;

const char *
get_var(variable_t *vars, const char *name);

const char *
get_var_len(variable_t *vars, const char *name, size_t len);

int
set_var(variable_t **vars, const char *name, const char *value);

int
drop_var(variable_t **vars, const char *name);

int
purge_var(variable_t **vars, const char *name);

void
drop_vars(variable_t **vars);

void
purge_vars(variable_t **vars);

char *
substitute(const char *str, variable_t *vars);

char *
safe_substitute(const char *str, variable_t *vars);

#endif /* __VARS_H */
