/*
 * Copyright (C) 2002 Bartosz Lis <bartoszl@ics.p.lodz.pl>
 * This is the main module
 */

%{

#define _GNU_SOURCE

#include "config.h"

#include "cfg_file.h"
#include "cfg_parse_h.h"
#include "cfg_parser.h"

#define param_examine (((cfg_parser_t *)param)->examine)
#define param_error   (((cfg_parser_t *)param)->error)
#define param_status  (((cfg_parser_t *)param)->status)

#define APPEND if (!textrope_append(&lvalp->token,yyleng,yytext)) \
  { \
    sprintf(param_error,"Reading config file at %d:%d got error: short on memory",llocp->last_line+1,llocp->last_column+1); \
    param_status=ERR_SHORT_MEM; \
    return TOKEN_ERROR; \
  }

%}

%option never-interactive
%option noyywrap
%option stack

%x C_APO C_QUOT C_COMMENT C_REMARK

%%

[\ \t\r]+		{ 
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=0;
			  return TOKEN_WS;
			}
\\\n			{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column=0;
			  llocp->last_line++;
			  lvalp->token=0;
			  param_examine=0;
			  return TOKEN_WS;
			}
"#"|"//"		{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=0;
			  yy_push_state(C_REMARK);
			}
<C_REMARK>.+		{
			  llocp->last_column+=yyleng;
			}
<C_REMARK>\n		{
			  llocp->last_column=0;
			  llocp->last_line++;
			  yy_pop_state();
			  return TOKEN_NL;
			}
<INITIAL,C_REMARK><<EOF>>	{
			  lvalp->token=0;
			  param_examine=0;
			  return 0;
			}
\n+			{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column=0;
			  llocp->last_line+=yyleng;
			  lvalp->token=0;
			  param_examine=0;
			  return TOKEN_NL;
			}
mysql			{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=&lvalp->token;
			  APPEND
			  return TOKEN_MYSQL;
			}
[[:alpha:]_][[:alnum:]_]*	{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=&lvalp->token;
			  APPEND
			  return TOKEN_IDENTIFIER;
			}
":"[[:alpha:]_][[:alnum:]_]*	{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=&lvalp->token;
			  APPEND
			  return TOKEN_VAR;
			}
":"\{[[:alpha:]_][[:alnum:]_]*\}	{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=&lvalp->token;
			  APPEND
			  return TOKEN_VAR;
			}
0x[[:digit:]]+ |
[[:digit:]]+("."[[:digit:]]+)?(e[+-]?[[:digit:]])?	|
"."[[:digit:]]+(e[+-]?[[:digit:]])?	{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=&lvalp->token;
			  APPEND
			  return TOKEN_NUMBER;
			}
"/"|[-+*!~^&|()]+	{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=&lvalp->token;
			  APPEND
			  return TOKEN_OPERATOR;
			}
"="			{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=&lvalp->token;
			  APPEND
			  return TOKEN_EQ;
			}
"=dflt"/[^[:alnum:]_]	{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=&lvalp->token;
			  APPEND
			  return TOKEN_EQ_DFLT;
			}
","			{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=&lvalp->token;
			  APPEND
			  return TOKEN_COMMA;
			}
"."			{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=&lvalp->token;
			  APPEND
			  return TOKEN_DOT;
			}
"/*"			{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column+=yyleng;
			  lvalp->token=0;
			  param_examine=0;
			  yy_push_state(C_COMMENT);
			}
\"			{ /*"*/
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column++;
			  lvalp->token=0;
			  param_examine=&lvalp->token;
			  APPEND
			  yy_push_state(C_QUOT);
			}
\'			{
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column++;
			  lvalp->token=0;
			  param_examine=&lvalp->token;
			  APPEND
			  yy_push_state(C_APO);
			}
<C_COMMENT>[^*\n]+	{
			  llocp->last_column+=yyleng;
			}
<C_COMMENT>\n+		{
			  llocp->last_column=0;
			  llocp->last_line+=yyleng;
			}
<C_COMMENT>"*"+[^*\n/]+	{
			  llocp->last_column+=yyleng;
			}
<C_COMMENT>"*"+"/"	{
			  llocp->last_column+=yyleng;
			  yy_pop_state();
			  return TOKEN_WS;
			}
<C_QUOT>[^"\\\n]+	{ /*"*/
			  llocp->last_column+=yyleng;
			  APPEND
			}
<C_QUOT>\"		{
			  llocp->last_column++;
			  APPEND
			  yy_pop_state();
			  return TOKEN_QUOT;
			}
<C_APO>[^'\\\n]+	{
			  llocp->last_column+=yyleng;
			  APPEND
			}
<C_APO>\'		{
			  llocp->last_column++;
			  APPEND
			  yy_pop_state();
			  return TOKEN_APO;
			}
<C_QUOT,C_APO>\n+	{
			  llocp->last_column=0;
			  llocp->last_line+=yyleng;
			  APPEND
			}
<C_QUOT,C_APO>\\.	{
			  llocp->last_column+=yyleng;
			  APPEND
			}
<C_QUOT,C_APO>\\\n	{
			  llocp->last_column=0;
			  llocp->last_line++;
			  APPEND
			}
<C_COMMENT><<EOF>>	{
			  sprintf(param_error,"Reading config file at %d:%d got error: unexpected EOF in comment starting at %d:%d",llocp->last_line+1,llocp->last_column+1,llocp->first_line+1,llocp->first_column+1);
			  param_status=ERR_CFG_ERR;
			  return TOKEN_ERROR;
			}
<C_APO><<EOF>>		{
			  sprintf(param_error,"Reading config file at %d:%d got error: unexpected EOF in apostrophe citation starting at %d:%d",llocp->last_line+1,llocp->last_column+1,llocp->first_line+1,llocp->first_column+1);
			  textrope_destroy(&lvalp->token);
			  param_examine=0;
			  param_status=ERR_CFG_ERR;
			  return TOKEN_ERROR;
			}
<C_QUOT><<EOF>>		{
			  sprintf(param_error,"Reading config file at %d:%d got error: unexpected EOF in quotation starting at %d:%d",llocp->last_line+1,llocp->last_column+1,llocp->first_line+1,llocp->first_column+1);
			  textrope_destroy(&lvalp->token);
			  param_examine=0;
			  param_status=ERR_CFG_ERR;
			  return TOKEN_ERROR;
			}
.			{ 
			  llocp->first_line=llocp->last_line;
			  llocp->first_column=llocp->last_column;
			  llocp->last_column++;
			  sprintf(param_error,"Reading config file at %d:%d got error: unexpected character '%s'",llocp->first_line+1,llocp->first_column+1,yytext);
			  lvalp->token=0;
			  param_examine=0;
			  param_status=ERR_CFG_ERR;
			  return TOKEN_ERROR;
			}
%%

