/***************************************************************************
                          ann_w_step.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include <ann_w_step.h>

  //                    //
 // class ANN::WG_step //
//                    //

double
ANN::WG_step::get_random()
{
  return (2.0*rand())/RAND_MAX-1;
}

  //              //
 // class W_step //
//              //

ANN::W_step::~W_step()
{
}

void
ANN::W_step::commence(NE &ne)
{
  size_t  i, l=d.get_size();
  double *d_data=d.get_data();
  for (i=0; i<l; ++i) d_data[i]=0;
}

void
ANN::W_step::feed_back(const Term &d_)
{
  size_t        i, l=d.get_size();
  double       *d_data=d.get_data();
  const double *d_data_=d_.get_data();
  for (i=0; i<l; ++i) d_data[i]+=d_data_[i];
}

void
ANN::W_step::commit(NE &ne)
{
  size_t  i, l=w.get_size();
  double  etha=the_group().etha, *d_data=d.get_data(), *w_data=w.get_data();
  for (i=0; i<l; ++i)
  {
    w_data[i]+=etha*d_data[i];
    d_data[i]=0;
  }
}

