/***************************************************************************
                          ann_w_norm.cpp  -  description
                             -------------------
    begin                : czw wrz  4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include <math.h>

#include <ann_w_norm.h>

  //                   //
 // class ANN::W_norm //
//                   //

void
ANN::W_norm::normalize()
{
  size_t i, l=d.get_size();
  double norm=0, x, *w_data=w.get_data();
  for (i=0; i<l; ++i) 
  {
    x=w_data[i];
    norm+=x*x;
  }
  if (norm) 
  {
    norm=1/sqrt(norm);
    for (i=0; i<l; ++i) w_data[i]*=norm;
  }
}

void
ANN::W_norm::commence(NE &ne)
{
  normalize();
  W_step::commence(ne);
}

void
ANN::W_norm::commit(NE &ne)
{
  W_step::commit(ne);
  normalize();
}

