/***************************************************************************
                          ann_ls_set.cpp  -  description
                             -------------------
    begin                : pi kwi 18 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include <ann_ls_set.h>

  //                   //
 // ANN::LS::create() //
//                   //

ANN::LS *
ANN::LS::create()
{
  return new LS_set;
}

  //                   //
 // class ANN::LS_set //
//                   //

ANN::LS_set::~LS_set()
{
  Iterator  it;
  Log_rec  *log;
  while (!children.empty())
  {
    log=*(it=children.begin());
    children.erase(it);
    delete log;
  }
}

bool
ANN::LS_set::attach(Log_rec &child)
{
  return children.insert(&child).second;
}

bool
ANN::LS_set::detach(Log_rec &child)
{
  return children.erase(&child);
}

void
ANN::LS_set::commence()
{
  Iterator it=children.begin();
  Iterator end=children.end();
  while (it!=end) prop_commence(**it++);
}

void
ANN::LS_set::open(size_t epoch)
{
  Iterator it=children.begin();
  Iterator end=children.end();
  while (it!=end) prop_open(**it++,epoch);
}

void
ANN::LS_set::feed(size_t which_, const Loc *where_)
{
  Iterator it=children.begin();
  Iterator end=children.end();
  while (it!=end) prop_feed(**it++,which_,where_);
}

void
ANN::LS_set::close(size_t epoch)
{
  Iterator it=children.begin();
  Iterator end=children.end();
  while (it!=end) prop_close(**it++,epoch);
}

void
ANN::LS_set::conclude(size_t epoch)
{
  Iterator it=children.begin();
  Iterator end=children.end();
  while (it!=end) prop_conclude(**it++,epoch);
}

void
ANN::LS_set::concluded(size_t epoch)
{
  Iterator it=children.begin();
  Iterator end=children.end();
  while (it!=end) prop_concluded(**it++,epoch);
}
