/***************************************************************************
                          ann_ds_out.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include <ann_ds_out.h>

  //                   //
 // class ANN::DS_out //
//                   //

ANN::DS_out::~DS_out()
{
}

bool
ANN::DS_out::act_on(NE *elem_)
{
  if (elem_)
  {
    size_t l=elem_->get_in_size();
    if (!l || (l!=orig->get_size())) return false;
    out_data.resize(elem_->get_out_sizes());
  }
  else out_data.resize(Size());
  elem=elem_;
  return true;
}

const ANN::Size &
ANN::DS_out::get_sizes() const
{
  return out_data.get_sizes();
}

size_t
ANN::DS_out::get_size() const
{
  return out_data.get_size();
}

ANN::Term &
ANN::DS_out::term()
{
  return out_data;
}

const ANN::Term &
ANN::DS_out::term() const
{
  return out_data;
}

bool
ANN::DS_out::reset()
{
  bool ret=(elem && ANN::DS_rec::reset());
  if (ret) elem->feed(orig->term(),out_data);
  return ret;
}

void
ANN::DS_out::feed()
{
  if (elem)
  {
    ANN::DS_rec::feed();
    elem->feed(orig->term(),out_data);
  }
}

bool
ANN::DS_out::seek(size_t term_)
{
  bool ret=(elem && ANN::DS_rec::seek(term_));
  if (ret) elem->feed(orig->term(),out_data);
  return ret;
}

bool
ANN::DS_out::locate(const Loc &loc)
{
  bool ret=(elem && ANN::DS_rec::locate(loc));
  if (ret) elem->feed(orig->term(),out_data);
  return ret;
}

