/***************************************************************************
                          ann_ds_buff.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include <math.h>

#include <ann_ds_buff.h>

  //                    //
 // class ANN::DS_buff //
//                    //

ANN::TERM ANN::DS_buff::none;

ANN::DS_buff::~DS_buff()
{
  if (data) delete data;
}

void
ANN::DS_buff::rebuild(DS &that)
{
  if (data) delete data;
  data=new TS(that.get_lengths(),that.get_sizes());
  lengths=that.get_lengths();
  data->locate(current,0);
  loc.resize();
  lengths.next(loc);
  cur=0;
  size_t        i, n=lengths.total_size(), m=current.get_size();
  double       *next_=data->get_data(), *data_;
  const double *that_data;
  for (i=0; i<n; ++i)
  {
    data_=next_;
    next_+=m;
    if (i) that.feed(); else that.reset();
    if (that_data=that.term().get_data())
      while (data_<next_) *data_++=*that_data++;
  }
}

void
ANN::DS_buff::rebuild(const Term &data_)
{
  if (data) delete data;
  data=new TS(data_);
  data->query_lengths(lengths);
  current=*data;
  loc.resize();
  lengths.next(loc);
  cur=0;
}

void
ANN::DS_buff::rebuild(TS &data_) 
{
  if (data) delete data;
  data=&data_;
  data->query_lengths(lengths);
  data->locate(current,0);
  loc.resize();
  lengths.next(loc);
  cur=0;
}

bool
ANN::DS_buff::resize(const Size &sizes_)
{
  return set_limits(lengths,sizes_);
}

bool
ANN::DS_buff::set_length(const Size &lengths_)
{
  return set_limits(lengths_,current.get_sizes());
}

bool
ANN::DS_buff::set_limits(const Size &lengths_, const Size &sizes_)
{
  lengths=lengths_;
  if (data) data->set_limits(lengths,sizes_);
  else data=new TS(lengths,sizes_);
  data->locate(current,cur=0);
  loc.resize();
  lengths.next(loc);
  return true;
}

bool
ANN::DS_buff::reset()
{
  data->locate(current,cur=0);
  loc.resize();
  return lengths.next(loc);
}

void
ANN::DS_buff::feed()
{
  if ((cur<lengths.total_size()) && data) ++cur;
  else
  {
    cur=0;
    loc.resize();
  }
  data->locate(current,cur);
  lengths.next(loc);
}

bool
ANN::DS_buff::seek(size_t term_pos_)
{
  if ((term_pos_<lengths.total_size()) && lengths.locate(cur=term_pos_,loc)
      && data)
  {
    data->locate(current,cur);
    return true;
  }  
  cur=size_max;
  loc.resize();
  return false;
}

bool
ANN::DS_buff::locate(const Loc &loc_)
{
  if (((cur=lengths[loc_])!=size_max) && data)
  {
    loc=loc_;
    data->locate(current,cur);
    return true;
  }
  loc.resize();
  return false;
}

const ANN::Size &
ANN::DS_buff::get_lengths() const
{
  return lengths;
}

size_t
ANN::DS_buff::get_length() const
{
  return lengths.total_size();
}

const ANN::Size &
ANN::DS_buff::get_sizes() const
{
  return current.get_sizes();
}

size_t
ANN::DS_buff::get_size() const
{
  return current.get_size();
}

ANN::Term &
ANN::DS_buff::term()
{
  if (cur<lengths.total_size()) return current;
  none.resize(Size());
  return none;
}

const ANN::Term &
ANN::DS_buff::term() const
{
  if (cur<lengths.total_size()) return current;
  none.resize(Size());
  return none;
}

const ANN::Loc &
ANN::DS_buff::where() const
{
  return loc;
}

size_t
ANN::DS_buff::which() const
{
  return cur;
}

ANN::TS *
ANN::DS_buff::all_terms()
{
  return data;
}

const ANN::TS *
ANN::DS_buff::all_terms() const
{
  return data;
}

