/***************************************************************************
                          ann_ws_set.h  -  description
                             -------------------
    begin                : czw kwi 17 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_WS_SET_H
#define __ANN_WS_SET_H

#include <set>

#include <cmp_ptr.h>
#include <ann_weight.h>

namespace ANN {
  
  //              //
 // class WS_set //
//              //

  class WS_set : public WS
  {
  public:
    typedef std::set<W *,CmpPtr>  Ws;
    typedef Ws::iterator          Ws_it;
    typedef std::set<WG *,CmpPtr> WGs;
    typedef WGs::iterator         WGs_it;
    
  private:
    WS_set(const WS_set &that);

  protected:
    Ws  w_set;
    WGs g_set;

  public:
    WS_set() {}
    virtual ~WS_set();

    virtual void register_weight(W &w);
    virtual void erase_weights();
    virtual void reset(NE *ne);    /* resets weight befor training */
    virtual void commence(NE &ne); /* prepares to an epoch */
    virtual void commit(NE &ne);   /* updates value */
    virtual void conclude(NE &ne); /* training ends */
    virtual void randomize();      /* randomizes value */
    virtual bool load(Parser_log &parser, time_t begin=0,
                      time_t end=NAV_get(time_t)); /* loads from a log */
    virtual void store(Log &log);                  /* stores to a log */
  };

} // namespace ANN 

#endif /* __ANN_WS_SET_H */
