/***************************************************************************
                          ann_wg_set.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_WG_SET_H
#define __ANN_WG_SET_H

#include <set>

#include <cmp_ptr.h>
#include <ann_weight.h>
#include <ann_log.h>

namespace ANN
{

  template<class Weight, class Instance=typename Weight::Instance_t>
  class WG_set;

  //template<class Weight, class Instance>//
 // class WG_set                         //
//                                      //

  template <class Weight, class Instance>
  class WG_set : public virtual WG
  {
  public:
    typedef Weight                   W_t;
    typedef Log                      Common_t;
    typedef Instance                 Instance_t;
    typedef WG_set                   Base_t;
    typedef std::set<W_t *,CmpPtr>   W_set;
    typedef typename W_set::iterator W_it;

  private:
    WG_set(const WG_set &that);
    
  protected:
    W_set  w_set;

  public:
    WG_set(Log *log_=0) : WG(log_) {}
    WG_set(Log &log_) : WG(log_) {}
    WG_set(Log &log_, Instance_t inst) : WG(log_) {}
    WG_set(WGC &c) : WG(c) {}
    WG_set(WGC &c, Instance_t inst) : WG(c) {}
    virtual ~WG_set() {}

    virtual bool can_handle(Instance_t inst) { return true; }
    virtual void attach(W_t &w, Instance_t inst) { w_set.insert(&w); }
    virtual bool detach(W_t &w)
    {
      w_set.erase(&w);
      if (!w_set.empty()) return true;
      delete this;
      return false;
    }
    virtual bool has_label(const char *label);
    virtual void store_weights(Log &log_);
  };

  template <class Weight>
  class WG_set<Weight,void> : public virtual WG
  {
  public:
    typedef Weight                   W_t;
    typedef Log                      Common_t;
    typedef void                     Instance_t;
    typedef std::set<W_t *, CmpPtr>  W_set;
    typedef typename W_set::iterator W_it;

  private:
    WG_set(const WG_set &that);

  protected:
    W_set  w_set;
    Log   *log;

  public:
    WG_set(Log *log_) : WG(log_) {}
    WG_set(Log &log_) : WG(&log_) {}
    WG_set(WGC &c) : WG(c) {}
    virtual ~WG_set() {}

    virtual bool can_handle() { return true; }
    virtual void attach(W_t &w) { w_set.insert(&w); }
    virtual bool detach(W_t &w)
    {
      w_set.erase(&w);
      if (!w_set.empty()) return true;
      delete this;
      return false;
    }
    virtual bool has_label(const char *label);
    virtual void store_weights(Log &log_);
  };

} // namespace ANN

template<class Weight, class Instance>
bool
ANN::WG_set<Weight,Instance>::has_label(const char *label_)
{
  W_it it=w_set.begin();
  W_it end=w_set.end();
  while (it!=end) if ((*it++)->has_label(label_)) return true;
  return false;
}

template<class Weight, class Instance>
void
ANN::WG_set<Weight,Instance>::store_weights(Log &log_)
{
  if (log_.is_active())
  {
    W_it it=w_set.begin();
    W_it end=w_set.end();
    while (it!=end) (*it++)->store(log_);
  }
}

template<class Weight>
bool
ANN::WG_set<Weight,void>::has_label(const char *label_)
{
  W_it it=w_set.begin();
  W_it end=w_set.end();
  while (it!=end) if ((*it++)->has_label(label_)) return true;
  return false;
}

template<class Weight>
void
ANN::WG_set<Weight,void>::store_weights(Log &log_)
{
  if (log_.is_active())
  {
    W_it it=w_set.begin();
    W_it end=w_set.end();
    while (it!=end) (*it++)->store(*log_);
  }  
}

#endif /* __ANN_WG_SET_H */
