/***************************************************************************
                          ann_sink_ws.h  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_SINK_WS_H
#define __ANN_SINK_WS_H

#include <iostream>

#include <ann_sink.h>

namespace ANN
{

  class Sink_ws;

  //               //
 // class Sink_ws //
//               //

  class Sink_ws : public Sink
  {
  private:
    Sink_ws();
    Sink_ws(const Sink_ws &that);
    
  protected:
    std::ostream *os;
    size_t        last;
    
  public:
    Sink_ws(std::ostream &os_) : os(&os_), last(size_max) {}
    virtual ~Sink_ws();

    virtual bool open(Size lengths, Size sizes);
    virtual bool feed(size_t which_, const Loc &where_, const Term &in,
                      const char *label=0);
    virtual bool close();
  };

} // namespace ANN

#endif /* __ANN_SINK_WS_H */
