/***************************************************************************
                          ann_nit_kohonen.h  -  description
                             -------------------
    begin                : sob wrz  6 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NIT_KOHONEN_H
#define __ANN_NIT_KOHONEN_H

#include <ann_nit_basic.h>

namespace ANN
{

  class NITC_kohonen;
  class NIT_kohonen;
  
  //                    //
 // class NITC_kohonen //
//                    //

  class NITC_kohonen : public NITC_basic
  {
  public:
    NITC_kohonen(const NITC_basic &that) 
    : NITC_basic(that.out_size,that.log,that.wf,false) {}
    NITC_kohonen(const Size &out_size_, Log *log_, W_FB *wf_)
    : NITC_basic(out_size_,log_,wf_,false) {}
    NITC_kohonen(const Size &out_size_, W_FB *wf_)
    : NITC_basic(out_size_,0,wf_,false) {}
    
    NITC_kohonen &unbias() { bias=false; return *this; }
  };

  //                   //
 // class NIT_kohonen //
//                   //

  class NIT_kohonen : public NIT_basic
  {
  public:
    typedef NITC_kohonen   Common_t;
    typedef NE::Instance_t Instance_t;
    typedef NIT            Base_t;

  private:
    NIT_kohonen();
    NIT_kohonen(const NIT_kohonen &);

  public:
    NIT_kohonen(NITC_kohonen &c, const Init *inst) 
    : NIT_basic(c.unbias(),inst) {}
    virtual ~NIT_kohonen();

    virtual void        feed_back(const Term &in, const Term &out,
                                  const Term *out_fb, Term *in_fb);
  };
  
  typedef F<NIT_kohonen> NIT_kohonen_F;

} //namespace ANN

#endif /* __ANN_NIT_KOHONEN_H */

