/***************************************************************************
                          ann_eval_bprop.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_EVAL_BPROP_H
#define __ANN_EVAL_BPROP_H

#include <ann_eval.h>

namespace ANN
{

  class EvalC_bprop;
  class Eval_bprop;

  //                   //
 // class EvalC_bprop //
//                   //

  class EvalC_bprop : public EvalC
  {
  private:
    EvalC_bprop();

  public:
    DS     *ds;
    double  threshold;
    
    EvalC_bprop(NIT_FB &f_, DS &ds_, double  threshold_, Log *log_=0)
    : EvalC(f_,log_), ds(&ds_), threshold(threshold_) {}
    EvalC_bprop(NIT_FB *f_, DS &ds_, double  threshold_, Log *log_=0)
    : EvalC(f_,log_), ds(&ds_), threshold(threshold_) {}
    EvalC_bprop(DS &ds_, double  threshold_, Log *log_=0)
    : EvalC(log_), ds(&ds_), threshold(threshold_) {}
    EvalC_bprop(const EvalC_bprop &that)
    : EvalC(that), ds(that.ds), threshold(that.threshold) {}

    EvalC_bprop &operator = (const EvalC_bprop &that)
    {
      EvalC::operator = (that);
      ds=that.ds;
      threshold=that.threshold;
      return *this;
    }    
  };

  //                  //
 // class Eval_bprop //
//                  //

  class Eval_bprop : public Eval
  {
  public:
    typedef EvalC_bprop    Common_t;
    typedef NE::Instance_t Instance_t;
    typedef NIT            Base_t;

  private:
    Eval_bprop();
    Eval_bprop(const Eval_bprop &that);

  protected:
    DS     *des_output;
    double  error;
    char   *label_in;
    char   *label_out;
    char   *label_des_out;

  public:
    double  threshold;

    Eval_bprop(NIT &ne_, DS &ds_, double threshold_, Log *log_=0,
               const char *label_=0);
    Eval_bprop(NIT &ne_, DS &ds_, double threshold_, const char *label_);
    Eval_bprop(NIT *ne_, DS &ds_, double threshold_, Log *log_=0,
               const char *label_=0);
    Eval_bprop(NIT *ne_, DS &ds_, double threshold_, const char *label_);
    Eval_bprop(Size in_size_, DS &ds_, double threshold_, Log *log_=0,
               const char *label_=0);
    Eval_bprop(Size in_size_, DS &ds_, double threshold_, const char *label_);
    Eval_bprop(Common_t &c, Instance_t inst);
    virtual ~Eval_bprop();

    double                get_error() const { return error; }

    virtual Status        commence(DS &ds_, bool is_input);
    virtual void          conclude();
    virtual void          open();
    virtual void          feed_back(const Term &in, const Term &out,
                                    const Term *out_fb, Term *in_fb);
    virtual Status        close();
  };

  typedef F<Eval_bprop> Eval_bprop_F;
  
} //namespace ANN

#endif /* __ANN_EVAL_BPROP_H */
