/***************************************************************************
                          ann_weight.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <stdlib.h>

#include <ann_weight.h>

  //              //
 // class ANN::W //
//              //

ANN::W::~W()
{
  if (label) delete [] label;
}

bool
ANN::W::has_label(const char *label_)
{
  return !strcmp(label_,label);
}

ANN::WG *
ANN::W::get_group() const
{
  return 0;
}

void
ANN::W::reset(NE *ne)
{
}

void
ANN::W::commence(NE &ne)
{
}

void
ANN::W::conclude(NE &ne)
{
}

void
ANN::W::randomize()
{
  WG     *g=get_group();
  size_t  i;
  for (i=0; i<w.get_size(); ++i)
    w[i]=(g ? g->get_random() : WG::def_random());
}

bool
ANN::W::load(Parser_log &parser, time_t begin, time_t end)
{
  parser.clear();
  if ((begin!=NAV_get(time_t)) && !parser.seek(begin)) return false;
  if (!parser.find(label)) return false;
  if ((end!=NAV_get(time_t)) && (end<parser.when())) return false;
  if (!parser(end)) return false;
  if (parser.get_sizes(0)!=w.get_sizes()) return false;
  parser.build(w,Loc(),0);
  return true;
}

void
ANN::W::store(Log &log)
{
  log.log(w,label);
}

/*
void
ANN::W::drop_weights(WA &wa)
{
  size_t i, n=wa.get_size();
  for (i=0; i<n; ++i) if (wa[i]) delete wa[i];
}
*/

  //               //
 // class ANN::WG //
//               //

ANN::WG::~WG()
{
}

#define WGROUP_SIGNATURE "wieght_group["

bool
ANN::WG::signature_find(Parser_log &parser, time_t begin, time_t end)
{
  char   *tail, sep=parser.get_separator();
  size_t  l;
  bool    cont=true, ret;
  if ((begin!=NAV_get(time_t)) && !parser.seek(begin)) return false;
  while (cont)
  {
    tail=0;
    if (!parser.find(WGROUP_SIGNATURE,tail)) return false;
    if (!tail) return false;
    if ((end!=NAV_get(time_t)) && (end<parser.when())) ret=cont=false;
    else if (l=strlen(tail)) if (tail[--l]==']') while (l) if (tail[--l]!=sep)
    {
      tail[++l]=0;
      cont=!(ret=has_label(tail));
      break;
    }
    delete [] tail;
  }
  return ret;
}

void
ANN::WG::signature_write(Log &log_, W &w)
{
  log_.nl(0,WGROUP_SIGNATURE) << w.get_label() << ']';
}

void
ANN::WG::reset(NE *ne)
{
}

void
ANN::WG::reseted(NE *ne)
{
}

void
ANN::WG::commence(NE &ne)
{
}

void
ANN::WG::commenced(NE &ne)
{
}

void
ANN::WG::commit(NE &ne)
{
}

void
ANN::WG::commited(NE &ne)
{
  if (log)
  {
    store_weights(*log);
    store(*log);
  }
}

void
ANN::WG::conclude(NE &ne)
{
}

void
ANN::WG::concluded(NE &ne)
{
  if (log)
  {
    store_weights(*log);
    store(*log);
  }
}

double
ANN::WG::get_random()
{
  return def_random();
}

double
ANN::WG::def_random()
{
  return (2.0*rand())/RAND_MAX-1;
}

bool
ANN::WG::load(Parser_log &parser, time_t begin, time_t end)
{
  return true;
}

void
ANN::WG::store(Log &log_)
{
}

void
ANN::WG::store_weights(Log &log_)
{  
}

  //               //
 // class ANN::WS //
//               //

ANN::WS::~WS()
{
}

