/***************************************************************************
                          ann_tc.cpp  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_tc.h>

  //                    //
 // class ANN::TC::Pos //
//                    //

void
ANN::TC::Pos::inc_level()
{
  if (++lev>loc.dim()) loc.resize(lev);
  loc[lev-1]=0;
}

bool
ANN::TC::Pos::dec_level()
{
  if (!lev) return false;
  if (!--lev) return false;
  ++loc[lev-1];
  return true;
}

  //               //
 // class ANN::TC //
//               //

ANN::Size ANN::TC::none;

ANN::TC::~TC()
{
  if (size) delete [] size;
}

void
ANN::TC::recalc()
{
  if (!lim_valid)
  {
    length.resize();
    if (size)
    {
      delete [] size;
      size=0;
    }  
    num_seq=0;
    do_recalc();
    lim_valid=true;
  }
}

void
ANN::TC::put(const Loc &where, const Loc &loc, double val, size_t seq)
{
  do_put(*new Token(where,loc,val,seq));
  lim_valid=false;
}

double
ANN::TC::get(const Loc &where, const Loc &loc, size_t seq)
{
  if (seq>=num_seq) return NAN;
  Token  t(seq);
  size_t i=where.dim(), j;
  for (;;)
  {
    t.where.resize(i,where.get_coord());
    j=loc.dim();
    for (;;)
    {
      t.loc.resize(j,loc.get_coord());
      if (do_get(t)) return t.val;
      if (!j) break;
      --j;
    }
    if (!i) break;
    --i;
  }  
  return NAN;
}

ANN::TS *
ANN::TC::build(size_t seq)
{
  recalc();
  if (seq>=num_seq) return 0;
  TS     *ts=new TS(length,size[seq]);
  double *data=ts->get_data();
  Loc     where;
  Loc     loc;
  while (length.next(where)) while (size[seq].next(loc))
    *data++=get(where,loc,seq);
  return ts;
}

void
ANN::TC::build(Term &term, const Loc &where, size_t seq)
{
  Token   t(where,seq);
  double *data_=term.get_data();
  while (term.get_sizes().next(t.loc)) *data_++=do_get(t);
}

void
ANN::TC::shrink(const Loc &where)
{
  Token t(where);
  do_shrink(t);
  lim_valid=false;
}

void
ANN::TC::erase(const Loc &where, size_t seq)
{
  Token t(where,seq);
  do_erase(t);
  lim_valid=false;
}

void
ANN::TC::erase(const Loc &where)
{
  Token t(where);
  for (t.seq=0; t.seq<num_seq; ++t.seq) do_erase(t);
  lim_valid=false;
}

void
ANN::TC::clear()
{
  do_clear();
  length.resize();
  if (size)
  {
    delete [] size;
    size=0;
  }  
  num_seq=0;
  lim_valid=true;
}
