/***************************************************************************
                          ann_sink_ws.cpp  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_sink_ws.h>

  //                    //
 // class ANN::Sink_ws //
//                    //

ANN::Sink_ws::~Sink_ws()
{
}

bool
ANN::Sink_ws::open(Size lengths, Size sizes)
{
  last=size_max;
  return *os;
}

bool
ANN::Sink_ws::feed(size_t which_, const Loc &where_, const Term &in,
                   const char *label_)
{
  if (which_==last) *os << " | ";
  else 
  {
    if (last!=size_max) *os << std::endl;
    last=which_;
  }
  size_t        i, n=in.get_size();
  const double *data=in.get_data();
  for (i=0; i<n; ++i)
  {
    if (i) *os << ' ';
    *os << data[i];
  }
  return *os;
}

bool
ANN::Sink_ws::close()
{
  if (last!=size_max)
  {
    last=size_max;
    *os << std::endl << std::flush;
  }
  return *os;
}
