/***************************************************************************
                          ann_parser_log.cpp  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <ann_parser_log.h>
#include <ann_init.h>

static char **
mk_str_arr(const char * const *arr_)
{
  if (!arr_) return 0;
  size_t i, n=0;
  while (arr_[n]) ++n;
  typedef char *Str;
  char **arr=new Str[n+1];
  for (i=0; i<n; ++i) arr[i]=ANN::Label::dup_str(arr_[i]);
  arr[n]=0;
  return arr;
}

static bool
get_size_t(char *&str, size_t &val)
{
  char    buff[20];
  size_t  i=0;
  while ((i<sizeof(buff)-1) && ('0'<=*str) && (*str<='9')) buff[i++]=*str++;
  if (!i || (i==sizeof(buff)-1)) return false;
  buff[i]=0;
  return sscanf(buff,"%lu",&val)==1;
}

  //                       //
 // class ANN::Parser_log //
//                       //

#define PARSER_LOG_BUFF_LEN 1024

ANN::Parser_log::Parser_log(const char *label_, std::istream &is_,
                            char sublevel_beg, char sublevel_end, char sep_)
: tc(TC::create()), is(&is_), time(&Time::format), last_stamp(0),
  label(Label::dup_str(label_)), seq_labels(0),
  buff(new char[PARSER_LOG_BUFF_LEN]), pos(0), len(0), after_stamp(false)
{
  set_separator(sep_);
  set_sublevel(sublevel_beg,sublevel_end);
}

ANN::Parser_log::Parser_log(const char *label_,
                            const char * const * seq_labels_,
                            std::istream &is_,
                            char sublevel_beg, char sublevel_end, char sep_)
: tc(TC::create()), is(&is_), time(&Time::format), last_stamp(0),
  label(Label::dup_str(label_)), seq_labels(mk_str_arr(seq_labels_)),
  buff(new char[PARSER_LOG_BUFF_LEN]), pos(0), len(0), after_stamp(false)
{
  set_separator(sep_);
  set_sublevel(sublevel_beg,sublevel_end);
}

ANN::Parser_log::Parser_log(const char *label_, std::istream &is_, Time &time_,
                            char sublevel_beg, char sublevel_end, char sep_)
: tc(TC::create()), is(&is_), time(&time_), last_stamp(0),
  label(Label::dup_str(label_)), seq_labels(0),
  buff(new char[PARSER_LOG_BUFF_LEN]), pos(0), len(0), after_stamp(false)
{
  set_separator(sep_);
  set_sublevel(sublevel_beg,sublevel_end);
}

ANN::Parser_log::Parser_log(const char *label_,
                            const char * const * seq_labels_,
                            std::istream &is_, Time &time_,
                            char sublevel_beg, char sublevel_end, char sep_)
: tc(TC::create()), is(&is_), time(&time_), last_stamp(0),
  label(Label::dup_str(label_)), seq_labels(mk_str_arr(seq_labels_)),
  buff(new char[PARSER_LOG_BUFF_LEN]), pos(0), len(0), after_stamp(false)
{
  set_separator(sep_);
  set_sublevel(sublevel_beg,sublevel_end);
}

ANN::Parser_log::~Parser_log()
{
  if (tc) delete tc;
  if (label) delete [] label;
  if (seq_labels)
  {
    const char * const * ptr=seq_labels;
    while (*ptr) delete [] *ptr++;
    delete [] seq_labels;
  }
}

void
ANN::Parser_log::add_word(size_t seq, const Loc &where, TC::Pos &pos_loc,
                          size_t l)
{
  char   tmp[20];
  double d;
  int    i;
  Loc    loc;
  pos_loc.get_loc(loc);
  if (l>=sizeof(tmp)-1) tc->put(where,loc,NAN,seq);
  else
  {
    strncpy(tmp,buff+pos,l)[l]=0;
    if (sscanf(tmp,"%lg",&d)==1) tc->put(where,loc,d,seq);
    else if (sscanf(tmp,"%i",&i)==1) tc->put(where,loc,i,seq);
    else tc->put(where,loc,NAN,seq);
  }
  pos_loc.next();
}

void
ANN::Parser_log::set_separator(char sep_)
{
  sep=(sep_ && (sep_!='\n') ? sep_ : ' ');
}

void
ANN::Parser_log::set_sublevel(char sublevel_beg, char sublevel_end)
{
  sub_beg=(sublevel_beg && (sublevel_beg!='\n')? sublevel_beg : '{');
  if (sublevel_end && (sublevel_end!='\n')) sub_end=sublevel_end;
  else switch (sub_beg)
  {
  case '(':
    sub_end=')';
    break;
  case '[':
    sub_end=']';
    break;
  case '<':
    sub_end='>';
    break;
  case '`':
    sub_end='\'';
    break;
  default:
    sub_end='}';
  }
  if (sub_beg==sub_end)
  {
    sub_beg='{';
    sub_end='}';
  }
}

bool
ANN::Parser_log::seek(time_t t)
{
  if (t<=last_stamp)
  {
    if (is->rdbuf()->pubseekoff(0,std::ios::beg,std::ios::in)
        !=std::streampos(0))
      return false;
    len=pos=0;
    last_stamp=0;
    after_stamp=false;
  }
  while (last_stamp<t) if (!shift()) return false;
  return true;
}

bool
ANN::Parser_log::shift()
{
  size_t i, l, p;
  time_t temp;
  p=pos;
  for(;;)
  {
    if (p==len)
    {
      if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
      len=p=l;
      pos=0;
      if (!(l=PARSER_LOG_BUFF_LEN-len)) return false;
      if (l=is->read(buff+len,l).gcount()) len+=l;
      else
      {
        len=pos=0;
        return false;
      }
    }
    if (after_stamp)
    {
      while (p<len) if (buff[p++]=='\n')
      {
        after_stamp=false;
        break;
      }
      pos=p;
    }
    else while (p<len) switch(buff[p++])
    {
    case '\t':
      after_stamp=true;
      if (l=p-pos-1)
      {
        stamp.resize(l);
        strncpy(stamp.c_str(),buff+pos,l)[l]=0;
        temp=time->parse(stamp);
        if ((temp!=NAV_get(time_t)) && (temp>=last_stamp))
        {
          last_stamp=temp;
          pos=p;
          return true;
        }
      }
    case '\n':
      pos=p;
    }
  }
}

bool
ANN::Parser_log::find(const char *label_, char *&tail)
{
  size_t i, j, l, p, llen;
  bool   ok;
  if (!after_stamp && !shift()) return false;
  if (!(llen==(label_ ? strlen(label_) : 0))) return true;
  p=pos;
  for(;;)
  {
    if (p==len)
    {
      if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
      len=p=l;
      pos=0;
      if (!(l=PARSER_LOG_BUFF_LEN-len)) return false;
      if (l=is->read(buff+len,l).gcount()) len+=l;
      else
      {
        len=pos=0;
        return false;
      }
    }
    j=p-pos;
    while (p<len) if ((buff[p]=='\n') || (buff[p]!=label_[j]))
    {
      shift();
      p=pos;
      j=0;
      break;
    }
    else
    {
      ++p;
      if (++j==llen)
      {
        pos=p;
        for (;;)
        {
          if (p==len)
          {
            if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
            len=p=l;
            pos=0;
            if (!(l=PARSER_LOG_BUFF_LEN-len)) return false;
            if (l=is->read(buff+len,l).gcount()) len+=l;
            else
            {
              p=pos;
              ok=false;
              break;
            }
          }
          while ((p<len) && (buff[p]==sep)) pos=++p;
        }
        ok=true;
        while (ok)
        {
          if (p==len)
          {
            if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
            len=p=l;
            pos=0;
            if (!(l=PARSER_LOG_BUFF_LEN-len)) return false;
            if (l=is->read(buff+len,l).gcount()) len+=l;
            else
            {
              l=p;
              break;
            }
          }
          while(p<len) if (buff[p]=='\n')
          {
            l=p++;
            after_stamp=false;
            ok=false;
            break;            
          }
          else if (buff[p]==sub_beg)
          {
            l=p;
            ok=false;
            break;
          }
          else ++p;
        }
        while ((l>pos) && (buff[l-1])==sep) --l;
        if (l-=pos)
        {
          tail=new char[l+1];
          strncpy(tail,buff+pos,l)[l]=0;
        }
        else tail=0;
        pos=p;
        return true;
      }
    }
  }
}

bool
ANN::Parser_log::find(const char *label_=0)
{
  char *tail;
  for (;;)
  {
    tail=0;
    if (!find(label_,tail)) return false;
    if (tail) delete [] tail;
    else return true;
  }
}

bool
ANN::Parser_log::parse(time_t end)
{
  char   *tail=0;
  Loc     where;
  size_t  seq, i, l;
  while (*is && find(label,tail))
  {
    if ((end!=NAV_get(time_t)) && (end<last_stamp)) break;
    if (tail)
    {
      if (seq_labels)
      {
        while (*is && seq_labels[seq])
        {
          while (tail[i] && (seq_labels[seq][i]==tail[i])) ++i;
          if (!seq_labels[seq][i])
          {
            where.resize();
            while (tail[i]==sep) ++i;            
            if (tail[i])
            {
              char *str=tail+i;
              if (('0'<=*str) && (*str<='9'))
              {
                if (!get_size_t(str,l)) break;
                while (*str==sep) ++str;
                if (*str && strncmp(str,"=>",2)) break;
                while (*str==sep) ++str;
                where << l;
              }
              if (*str) if (*str!='[') break;
              else
              {
                where.resize();
                while (*str)
                {
                  ++str;
                  if (!get_size_t(str,l))
                  {
                    str=tail+i;
                    break;
                  }  
                  where << l;
                  if (*str!=',') break;
                }
                if (*str!=']') break;
                if (*++str) break;
              }
              if (!load(seq,where)) tc->erase(where,seq);
            }
            break;
          }  
        }
      }
      delete [] tail;
      tail=0;
    }  
    else
    {
      where.resize();
      if (!seq_labels && !load(0,where)) tc->erase(where,0);
    }  
  }
  return *is;  
}

bool
ANN::Parser_log::load(size_t seq, const Loc &where)
{
  size_t  i, l, p;
  bool    ok=true;
  TC::Pos pos_loc;
  p=pos;
  while (ok)
  {
    if (!after_stamp)
    {
      if (!shift()) return false;
      p=pos;
    }
    if (p==len)
    {
      if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
      len=p=l;
      pos=0;
      if (!(l=PARSER_LOG_BUFF_LEN-len)) return false;
      if (l=is->read(buff+len,l).gcount()) len+=l;
      else
      {
        len=pos=0;
        return false;
      }
    }
    while (p<len) if (buff[p]=='\n')
    {
      pos=++p;
      after_stamp=false;
    }
    else if (buff[p]==sub_beg)
    {
      pos=++p;
      ok=false;
      pos_loc.inc_level();
      break;
    }
    else ++p;
  }
  for(;;)
  {
    if (!after_stamp)
    {
      if (!shift()) return false;
      p=pos;
    }
    if (p==len)
    {
      if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
      len=p=l;
      pos=0;
      if (!(l=PARSER_LOG_BUFF_LEN-len)) return false;
      if (l=is->read(buff+len,l).gcount()) len+=l;
      else
      {
        l=p-pos;
        p=pos;
        len=pos=0;
        return false;
      }
    }
    while (p<len) if (buff[p]=='\n')
    {
      if (l=p-pos) add_word(seq,where,pos_loc,l);
      pos=++p;
      after_stamp=false;
    }
    else if (buff[p]==sub_beg)
    {
      if (l=p-pos) add_word(seq,where,pos_loc,l);
      pos=++p;
      pos_loc.inc_level();
    }
    else if (buff[p]==sub_end)
    {
      if (l=p-pos) add_word(seq,where,pos_loc,l);
      pos=++p;
      if (!pos_loc.dec_level()) return true;
    }
    else if (buff[p]==sep)
    {
      if (l=p-pos) add_word(seq,where,pos_loc,l);
      pos=++p;
    }
    else ++p;
  }
}
