/***************************************************************************
                          ann_nfb_perc.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_nfb_perc.h>

  //                //
 // class NFB_perc //
//                //

ANN::NFB_perc::NFB_perc(NFBC_perc &c, const Init *inst)
: NFB(c.log,inst), out_size(c.out_size), bias(c.bias), w(c.out_size),
  act(c.act), sum(c.out_size), w_grad(inst->size.total_size()+c.bias)
{
  Init sub_inst(inst->size.total_size()+bias,label);
  sub_inst.set_label("neuron",sub_inst.length());
  size_t pos=sub_inst.length(), i, l=c.out_size.total_size();
  for (i=0; i<l; ++i)
  {
    sub_inst.set_index(i,pos);
    sub_inst.set_label("weights",sub_inst.length());
    w[i]=c.wf->create(&sub_inst);
  }
}

ANN::NFB_perc::~NFB_perc()
{
//  W::drop_weights(w);
}

const ANN::Size &
ANN::NFB_perc::get_out_sizes() const
{
  return out_size;
}

size_t
ANN::NFB_perc::get_out_size() const
{
  return out_size.total_size();
}

void
ANN::NFB_perc::register_weights(TO &torg)
{
  NFB::register_weights(torg);
  size_t i, n=out_size.total_size();
  for (i=0; i<n; ++i) torg.register_weight(*w[i]);
}

ANN::NE::Status
ANN::NFB_perc::close()
{
  return dumb;
}

ANN::NE::Status
ANN::NFB_perc::feed(const Term &in, Term &out)
{
  size_t        i, n=out_size.total_size();
  size_t        j, m=in_size.total_size();
  const double *x=in.get_data(), *u;
  double       *X=sum.get_data();
  for (i=0; i<n; ++i)
  {
    u=w[i]->values().get_data();
    X[i]=(bias ? u[m] : 0);
    for (j=0; j<m; ++j) X[i]+=x[j]*u[j];
    out[i]=(*act)(X[i],out[i]);
  }
  if (log && log->is_active()) log->log(out,label);
  return done;
}

bool
ANN::NFB_perc::fb_accept() const
{
  return true;
}

void
ANN::NFB_perc::feed_back(const Term &in, const Term &out,
                         const Term *out_fb, Term *in_fb)
{
  size_t        i, n=out_size.total_size();
  size_t        j, m=in_size.total_size()+bias;
  TERM          grad(m);
  const double *u, *x=in.get_data(), *y=out.get_data(), *e=out_fb->get_data();
  double       *X=sum.get_data(), *d=grad.get_data(), E, *e_;
  if (bias) --m;
  if (in_fb)
  {
    e_=in_fb->get_data();
    for (j=0; j<m; ++j) e_[j]=0;
  }  
  for (i=0; i<n; ++i)
  {
    E=(*act)(X[i],y[i],E);
    E*=e[i];
    u=w[i]->values().get_data();
    if (bias) d[m]=-E;
    for (j=0; j<m; ++j)
    {
      if (in_fb) e_[j]+=E*u[j];
      d[j]=-E*x[j];
    }  
    w[i]->feed_back(grad);
  }
}

