/***************************************************************************
                          ann_nfb_mlayer.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_nfb_mlayer.h>

  //                       //
 // class ANN::NFB_mlayer //
//                       //

ANN::NFB_mlayer::LayerData::LayerData(NFB &elem_, NFB *former)
: elem(&elem_), in(former ? new TERM(elem_.get_in_sizes()) : 0),
  in_fb(former && former->fb_accept() ? new TERM(elem_.get_in_sizes()) : 0)
{
}

ANN::NFB_mlayer::~NFB_mlayer()
{
  L_it it=layers.begin();
  L_it end=layers.end();
  while (it!=end) delete *it++;
}

bool
ANN::NFB_mlayer::add_layer(NFB *elem_)
{
  if (!elem_) return false;
  size_t s=(layers.size() ? layers.back()->elem->get_out_size()
                          : in_size.total_size());
  if (!s || (s!=elem_->get_in_size())) return false;
  layers.push_back(new LayerData(*elem_,layers.size() ? layers.back()->elem
                                                      : 0));
  return true;
}

bool
ANN::NFB_mlayer::add_layer(NFB_FB *factory)
{
  if (!factory) return false;
  Init inst(layers.size() ? layers.back()->elem->get_out_sizes() : in_size,
            label);
  if (!inst.size.total_size()) return false;
  inst.set_label("layer",inst.length());
  inst.set_index(layers.size(),inst.length());
  NFB *elem_=factory->create(&inst);
  layers.push_back(new LayerData(*elem_,layers.size() ? layers.back()->elem
                                                      : 0));
  return true;
}

const ANN::Size &
ANN::NFB_mlayer::get_out_sizes() const
{
  return layers.size() ? layers.back()->elem->get_out_sizes() : in_size;
}

size_t
ANN::NFB_mlayer::get_out_size() const
{
  return layers.size() ? layers.back()->elem->get_out_size()
                       : in_size.total_size();
}

ANN::NE::Status
ANN::NFB_mlayer::feed(const Term &in, Term &out)
{
  Status ret=done;
  L_it   it=layers.begin();
  L_it   end=layers.end();
  if (it==end) out=in;
  else
  {
    const Term *in_=&in;
    Term       *out_;
    LayerData  *l;
    do
    {
      l=*it++;
      ret=l->elem->feed(*in_, *(out_=(it==end ? &out : (*it)->in)))+ret;
      in_=out_;
    }
    while ((it!=end) && (ret!=wrong));
  }
  return ret;
}

void
ANN::NFB_mlayer::reset(bool prod)
{
  L_it it=layers.begin();
  L_it end=layers.end();
  while (it!=end) (*it++)->elem->reset(prod);
}

bool
ANN::NFB_mlayer::load(Parser_log &parser, time_t begin, time_t end)
{
  L_it it=layers.begin();
  L_it e=layers.end();
  while (it!=e) if (!(*it++)->elem->load(parser,begin,end)) return false;
  return true;
}

void
ANN::NFB_mlayer::store(Log &log_)
{
  L_it it=layers.begin();
  L_it end=layers.end();
  while (it!=end) (*it++)->elem->store(log_);
}

void
ANN::NFB_mlayer::randomize()
{
  L_it it=layers.begin();
  L_it end=layers.end();
  while (it!=end) (*it++)->elem->randomize();
}

void
ANN::NFB_mlayer::register_weights(TO &torg_)
{
  NFB::register_weights(torg_);
  L_it it=layers.begin();
  L_it end=layers.end();
  while (it!=end) (*it++)->elem->register_weights(torg_);
}

ANN::NE::Status
ANN::NFB_mlayer::commence(DS &ds_, bool is_input)
{
  Status ret=dumb;
  L_it it=layers.begin();
  L_it end=layers.end();
  if (it!=end) do
  {
    ret=(*it++)->elem->commence(ds_,is_input)+ret;
    is_input=false;
  }
  while ((it!=end) && (ret!=wrong));
  else if (is_input && (ds_.get_size()!=in_size.total_size())) ret=wrong;
  return ret;
}

void
ANN::NFB_mlayer::conclude()
{
  L_it it=layers.begin();
  L_it end=layers.end();
  while (it!=end) (*it++)->elem->conclude();
}

void
ANN::NFB_mlayer::open()
{
  L_it it=layers.begin();
  L_it end=layers.end();
  while (it!=end) (*it++)->elem->open();
}

ANN::NE::Status
ANN::NFB_mlayer::close()
{
  Status ret=dumb;
  L_it it=layers.begin();
  L_it end=layers.end();
  while ((it!=end) && (ret!=wrong)) ret=(*it++)->elem->close()+ret;
  return ret;
}

bool
ANN::NFB_mlayer::fb_accept() const
{
  return layers.empty() || layers.back()->elem->fb_accept();
}

void
ANN::NFB_mlayer::feed_back(const Term &in, const Term &out,
                           const Term *out_fb, Term *in_fb)
{
  L_rit       it=layers.rbegin();
  L_rit       end=layers.rend();
  const Term *in_, *out_=&out, *out_fb_=out_fb;
  Term       *in_fb_;
  LayerData *l;
  if (it!=end) do
  {
    l=*it++;
    l->elem->feed_back(*(in_=(it==end ? &in : l->in)), *out_,
                       out_fb_, in_fb_=(it==end ? in_fb : l->in_fb));
    out_=in_;
    out_fb_=in_fb_;
  }
  while (it!=end);
  else if (out_fb && in_fb) *in_fb=*out_fb;
}

