/***************************************************************************
                          ann_ne.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
 
#include <ann_ne.h>

  //               //
 // class ANN::NE //
//               //

size_t          single_out_size_arr[] = { 1 };
const ANN::Size ANN::NE::single_out_size(1,single_out_size_arr);

ANN::NE::NE(Size in_size_, Log &log_, const char *label_)
: label(Init::dup_str(label_ ? label_ : "neuron")), in_size(in_size_),
  log(&log_)
{
}

ANN::NE::NE(Size in_size_, Log *log_, const char *label_)
: label(Init::dup_str(label_ ? label_ : "neuron")), in_size(in_size_),
  log(log_)
{
}

ANN::NE::NE(Size in_size_, const char *label_)
: label(Init::dup_str(label_ ? label_ : "neuron")), in_size(in_size_), log(0)
{
}

ANN::NE::~NE()
{
  if (label) delete [] label;
}

const ANN::Size &
ANN::NE::get_out_sizes() const
{
  return single_out_size;
}

size_t
ANN::NE::get_out_size() const
{
  return get_out_sizes().total_size();
}

void
ANN::NE::reset(bool prod)
{
}

bool
ANN::NE::load(Parser_log &parser, time_t begin, time_t end)
{
  return true;
}

void
ANN::NE::store(Log &log_)
{
}

void
ANN::NE::randomize()
{
}

ANN::NE::Status ANN::operator + (ANN::NE::Status s1, ANN::NE::Status s2)
{
  if ((s1==ANN::NE::wrong) || (s2==ANN::NE::wrong)) return ANN::NE::wrong;
  if ((s1==ANN::NE::done) || (s2==ANN::NE::done)) return ANN::NE::done;
  if ((s1==ANN::NE::never) || (s2==ANN::NE::never)) return ANN::NE::never;
  if ((s1==ANN::NE::not_yet) || (s2==ANN::NE::not_yet))
    return ANN::NE::not_yet;
  return ANN::NE::dumb;
}
