/***************************************************************************
                          ann_log.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include <ann_log.h>

  //                //
 // class ANN::Log //
//                //

ANN::Log::~Log()
{
  if (children) delete children;
}

void
ANN::Log::log_term(const Term &t, const char *label, size_t which,
                   const Loc *where)
{
  size_t i, l=t.get_size(), d=t.get_sizes().dim();
  char   sub_beg=get_sublevel_beg();
  char   sub_end=get_sublevel_end();
  nl(0,label);
  if (which!=size_max)
  {
    log_uint(which);
    if (where) log_str("=>");
  }  
  if (where) log_loc(*where);
  if (!l || (d==1) || (!sub_beg && !sub_end))
  {
    if (sub_beg) log_chr(sub_beg);
    for (i=0; i<l; ++i) log_double(t[i]);
    if (sub_end) log_chr(sub_end);
  }
  else
  {
    Loc    incr(t.get_sizes()), lim(d,size_t(0));
    size_t j;
    i=1;
    for (j=d-1; j>0; --j) i=(incr[j]*=i);
    incr[0]=l;
    i=0;
    while (i<l)
    {
      for (j=d-1; i==lim[j]; --j)
      {
        lim[j]+=incr[j];
        nl(0,0);
        if (sub_beg) log_chr(sub_beg);
        nl(1,0);
        if (!j) break;
      }
      log_double(t[i]);
      ++i;
      for (j=d-1; i==lim[j]; --j)
      {
        nl(-1,0);
        if (sub_end) log_chr(sub_end);
        nl(0,0);
        if (!j) break;
      }  
    }
  }
  nl(0,0);
}

bool
ANN::Log::attach(Log_rec &child)
{
  if (!children) children=LS::create();
  return children->attach(child);
}

bool
ANN::Log::detach(Log_rec &child)
{
  return children && children->detach(child);
}

bool
ANN::Log::is_active() const
{
  return true;
}

void
ANN::Log::commence(const char *label_)
{
  if (children) children->commence();
}

void
ANN::Log::open(size_t epoch)
{
  if (children) children->open(epoch);
}

void
ANN::Log::feed(size_t which_, const Loc *where_)
{
  if (children) children->feed(which_,where_);
}

void
ANN::Log::close(size_t epoch)
{
  if (children) children->close(epoch);
}

void
ANN::Log::conclude(size_t epoch)
{
  if (children) children->conclude(epoch);
}

void
ANN::Log::concluded(size_t epoch)
{
  if (children) children->concluded(epoch);
}

  //                    //
 // class ANN::Log_rec //
//                    //

ANN::Log_rec::~Log_rec()
{
  orig->detach(*this);
}

void
ANN::Log_rec::new_line(int ch_marg, const char *label)
{
  if (active) orig->nl(ch_marg,label);
}

void
ANN::Log_rec::log_chr(char chr)
{
  if (active) orig->log(chr);
}

void
ANN::Log_rec::log_str(const char *str)
{
  if (active) orig->log(str);
}

void
ANN::Log_rec::log_int(int i)
{
  if (active) orig->log(i);
}

void
ANN::Log_rec::log_uint(unsigned int u)
{
  if (active) orig->log(u);
}

void
ANN::Log_rec::log_double(double d)
{
  if (active) orig->log(d);
}

void
ANN::Log_rec::log_loc(const Loc &loc)
{
  if (active) orig->log(loc);
}

void
ANN::Log_rec::log_size(const Size &size)
{
  if (active) orig->log(size);
}

void
ANN::Log_rec::log_term(const Term &t, const char *label, size_t which,
                       const Loc *where)
{
  if (active) orig->log(t,label,which,where);
}

void
ANN::Log_rec::prop_commence()
{
  if (children) children->commence();
}

void
ANN::Log_rec::prop_open(size_t epoch)
{
  if (children) children->open(epoch);
}

void
ANN::Log_rec::prop_feed(size_t which_, const Loc *where_)
{
  if (children) children->feed(which_,where_);
}

void
ANN::Log_rec::prop_close(size_t epoch)
{
  if (children) children->close(epoch);
}

void
ANN::Log_rec::prop_conclude(size_t epoch)
{
  if (children) children->conclude(epoch);
}

void
ANN::Log_rec::prop_concluded(size_t epoch)
{
  if (children) children->concluded(epoch);
}

ANN::Time &
ANN::Log_rec::get_time() const
{
  return orig->get_time();
}

char
ANN::Log_rec::get_separator() const
{
  return orig->get_separator();
}

char
ANN::Log_rec::get_sublevel_beg() const
{
  return orig->get_sublevel_beg();
}

char
ANN::Log_rec::get_sublevel_end() const
{
  return orig->get_sublevel_end();
}

size_t
ANN::Log_rec::get_margin() const
{
  return orig->get_margin();
}

bool
ANN::Log_rec::is_active() const
{
  return active;
}

void
ANN::Log_rec::commence(const char *label_)
{
  active=false;
  orig->commence(label_);
}

void
ANN::Log_rec::open(size_t epoch)
{
  orig->open(epoch);
}

void
ANN::Log_rec::feed(size_t which_, const Loc *where_)
{
  orig->feed(which_,where_);
}

void
ANN::Log_rec::close(size_t epoch)
{
  orig->close(epoch);
}

void
ANN::Log_rec::conclude(size_t epoch)
{
  orig->conclude(epoch);
}

void
ANN::Log_rec::concluded(size_t epoch)
{
  orig->concluded(epoch);
}

ANN::Log &
ANN::Log_rec::flush()
{
  orig->flush();
  return *this;
}

  //               //
 // class ANN::LS //
//               //

ANN::LS::~LS()
{  
}
