/***************************************************************************
                          ann_ds_tee.cpp  -  description
                             -------------------
    begin                : wto kwi 15 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <stdio.h>
 
#include <ann_ds_tee.h>
#include <ann_init.h>

  //              //
 // class DS_tee //
//              //

ANN::DS_tee::DS_tee(DS &orig_, Sink &sink_, const char *label_)
: DS_rec(orig_), sink(&sink_), label(Init::dup_str(label_)), active(false)
{  
}

ANN::DS_tee::~DS_tee()
{
  if (active) sink->close();
  if (label) delete [] label;
}

void ANN::DS_tee::store_term()
{
  if (active && (last!=where()))
  {
    active=sink->feed(which(),last=where(),term(),label);
    if (!active) sink->close();
  }
}

bool
ANN::DS_tee::reset()
{
  if (active) sink->close();
  bool ret=DS_rec::reset();
  active=sink->open(get_lengths(),get_sizes());
  store_term();
  return ret;
}

void
ANN::DS_tee::feed()
{
  ANN::DS_rec::feed();
  store_term();
}

bool
ANN::DS_tee::seek(size_t term_pos_)
{
  bool ret=ANN::DS_rec::seek(term_pos_);
  if (ret) store_term();
  return ret;
}

bool
ANN::DS_tee::locate(const Loc &loc)
{
  bool ret=ANN::DS_rec::locate(loc);
  if (ret) store_term();
  return ret;
}
