/***************************************************************************
                          ann_cybenko.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_cybenko.h>

ANN::NFB_mlayer *
ANN::create_Cybenko(Log *log, const char *label, size_t in, size_t hidden,
                    size_t out, W_FB &w, Act &act, bool bias)
{
  Init inst(in,label ? label : "Cybenko_net");
  NFBC_perc hid_par(hidden,log,&w,act,bias);
  NFBC_perc out_par(out,log,&w,Act::linear,bias);
  NFB_perc_F *factory[]=
  {
    new NFB_perc_F(hid_par),
    new NFB_perc_F(out_par),
  };
  NFB_mlayer *ret=new NFB_mlayer(&inst,log,factory,factory+2);
  NFB_mlayer::drop_f(factory,factory+2);
  return ret;
}
