/***************************************************************************
                          ann_act.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <ann_act.h>

  //                //
 // class ANN::Act //
//                //

ANN::Act_sigmoidal ANN::Act::sigmoidal;
ANN::Act_linear    ANN::Act::linear;

  //                          //
 // class ANN::Act_sigmoidal //
//                          //

double
ANN::Act_sigmoidal::fun(const double **X, size_t order) const
{
  double y;
  if (order && X[1]) y=*X[1];
  else if ((y=*X[0])<0)
  {
    y=exp(y);
    y=y/(1+y);
  }
  else
  {
    y=exp(-y);
    y=1/(1+y);
  }
  switch (order)
  {
  case 0:
    return y;
  case 1:
    return y*(1-y);
  case 2:
    return y*(1-y)*(1-2*y);
  }
  return NAN;
}

  //                       //
 // class ANN::Act_linear //
//                       //

double
ANN::Act_linear::fun(const double **X, size_t order) const
{
  switch (order)
  {
  case 0:
    return *X[0];
  case 2:
    return 1;
  default:  
    return 0;
  }
}

  //                          //
 // class ANN::Act_threshold //
//                          //

double
ANN::Act_threshold::fun(const double **X, size_t order) const
{
  if (order) return NAN;
  double x=*X[0];
  if (x<threshold) return low;
  if (x>threshold) return high;
  if (edge!=NAN) return edge;
  if (X[1]) return *X[1];
  return NAN;
}
