/***************************************************************************
                          ann_ts.h  -  description
                             -------------------
    begin                : sob maj 3 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_TS_H
#define __ANN_TS_H

#include <ann_term.h>
#include <ann_factory.h>

namespace ANN
{

  class TS; /* training sequence */

  //          //
 // class TS //
//          //
 
  class TS : public TERM
  {
  public:
    typedef TERM::Elem_t Elem_t;
    typedef TERM::Item_t Item_t;

  protected:
    size_t dim_div;
    size_t total_term;
    size_t total_length;

  public:
    virtual bool resize(const Size &limits_, bool keep=true);
    void         set_dim_div(size_t dim_div_);
    size_t       get_dim_div() const { return dim_div; }
    bool         set_limits(const Size &lengths_, const Size &sizes_,
                            bool keep=true);
    void         query_lengths(Size &lengths_) const;
    void         query_sizes(Size &sizes_) const;
    void         query_limits(Size &lengths_, Size &sizes_) const
    { query_lengths(lengths_); query_sizes(sizes_); }

    TS() : dim_div(0), total_term(0), total_length(0) {}
    TS(const TS &that)
    : TERM(that), dim_div(that.dim_div), total_term(that.total_term),
      total_length(that.total_length) {}
    TS(const Term &that)
    : TERM(that), dim_div(0), total_term(that.get_size()), total_length(1) {}
    TS(const Size &lengths_, size_t dim_div_, const Item_t *data_=0)
    : TERM(lengths_,data_) { set_dim_div(dim_div_); }
    TS(const Size &lengths_, const Size &sizes_, const Item_t *data_=0)
    { set_limits(lengths_, sizes_); if (data_) copy_data(data_); }
    virtual ~TS();

    Elem_t       *get_data() { return data; }
    const Item_t *get_data() const { return data; }
    Elem_t       *get_data(const Loc &where)
    {
      size_t idx=size.index(where);
      return (idx<total_length) && data ? 0 : data+idx;
    }
    const Item_t *get_data(const Loc &where) const
    {
      size_t idx=size.index(where);
      return (idx<total_length) && data ? 0 : data+idx;
    }
    Elem_t       *get_data(size_t which)
    { return (which<total_length) && data ? data+which*total_term : 0; }
    const Item_t *get_data(size_t which) const
    { return (which<total_length) && data ? data+which*total_term : 0; }
    void          locate(Term &term, size_t which);
    void          locate(Term &term, const Loc &where);
    
    TS &operator = (const TS &that)
    {
      TERM::operator=(that);
      dim_div=that.dim_div;
      total_term=that.total_term;
      return *this;
    }
    TS &operator = (const Term &that)
    {
      TERM::operator=(that);
      dim_div=0;
      total_term=that.get_size();
      return *this;
    }
  };

} // namespace ANN

#endif /* __ANN_TS_H */
