/***************************************************************************
                          ann_nfb_bprop.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NFB_BPROP_H
#define __ANN_NFB_BPROP_H

#include <ann_nfb.h>

namespace ANN
{

  class NFBC_bprop;
  class NFB_bprop;

  //                  //
 // class NFBC_bprop //
//                  //

  class NFBC_bprop
  {
  private:
    NFBC_bprop();

  public:
    NFB_FB *f;
    Log    *log;
    DS     *ds;
    double  threshold;
    
    NFBC_bprop(NFB_FB &f_, DS &ds_, double  threshold_, Log *log_=0)
    : f(&f_), log(log_), ds(&ds_), threshold(threshold_) {}
    NFBC_bprop(const NFBC_bprop &that)
    : f(that.f), log(that.log), ds(that.ds), threshold(that.threshold) {}

    NFBC_bprop &operator = (const NFBC_bprop &that)
    {
      f=that.f;
      log=that.log;
      ds=that.ds;
      threshold=that.threshold;
      return *this;
    }    
  };

  //                 //
 // class NFB_bprop //
//                 //

  class NFB_bprop : public NFB
  {
  public:
    typedef NFBC_bprop     Common_t;
    typedef NE::Instance_t Instance_t;
    typedef NFB            Base_t;

  private:
    NFB_bprop();
    NFB_bprop(const NFB_bprop &that);

  protected:
    NFB    *ne;
    DS     *des_output;
    double  error;
    TERM    grad;
    char   *label_in;
    char   *label_out;
    char   *label_des_out;

  public:
    double  threshold;

    NFB_bprop(NFB &ne_, DS &ds_, double threshold_, Log *log_=0,
             const char *label_=0);
    NFB_bprop(NFB &ne_, DS &ds_, double threshold_, const char *label_);
    NFB_bprop(Common_t &c, Instance_t inst);
    virtual ~NFB_bprop();

    double                get_error() const { return error; }
    virtual const Size   &get_out_sizes() const;
    virtual size_t        get_out_size() const;
    virtual Status        feed(const Term &in, Term &out);

    virtual void          register_weights(TO &school_);
    virtual void          reset(bool prod=false);
    virtual bool          load(Parser_log &parser, time_t begin=0,
                               time_t end=NAV_get(time_t));
    virtual void          store(Log &log_);
    virtual void          randomize();
    virtual Status        commence(DS &ds_, bool is_input);
    virtual void          conclude();
    virtual bool          fb_accept() const;
    virtual void          feed_back(const Term &in, const Term &out,
                                    const Term *out_fb, Term *in_fb);
    virtual void          open();
    virtual Status        close();
  };

  typedef F<NFB_bprop> NFB_bprop_F;
  
} //namespace ANN

#endif /* __ANN_NFB_BPROP_H */
