/*****************************b**********************************************
                          ann_nfb.h  -  description
                             -------------------
    begin                : nie maj 11 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NFB_H
#define __ANN_NFB_H

#include <ann_to.h>

namespace ANN
{

  class NFB;

  //           //
 // class NFB //
//           //

  class NFB : public NIT
  {
  public:
    typedef Log         Common_t;
    typedef const Init *Instance_t;
    typedef NE          Base_t;

  private:
    NFB();
    NFB(const NE &that);

  public:
    NFB(Size in_size_, Log &log_, const char *label_=0)
    : NIT(in_size_,log_,label_) {}
    NFB(Size in_size_, Log *log_, const char *label_=0)
    : NIT(in_size_,log_,label_) {}
    NFB(Size in_size_, const char *label_=0) : NIT(in_size_,label_) {}
    NFB(Log &log_, Instance_t inst) : NIT(log_,inst) {}
    NFB(Log *log_, Instance_t inst) : NIT(log_,inst) {}
    NFB(Instance_t inst) : NIT(inst) {}
    
  public:
    virtual ~NFB();

    /** single epoch of training **/
    virtual bool          fb_accept() const=0;
    /* tells wheter this elent accepts feed back */
    virtual void          feed_back(const Term &in, const Term &out,
                                    const Term *out_fb, Term *in_fb)=0;
    /* called every time epoch starts */
    virtual void          adapt(const Term &in, Term &out);
    /* called to conduct epoch steps, after last step should return false */    
  };

  typedef FB<NFB,const Init *> NFB_FB;
  
} //namespace ANN

#endif /* __ANN_NFB_H */
