/***************************************************************************
                          ann_ne.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NE_H
#define __ANN_NE_H

#include <ctype.h>

#include <ann_loc.h>
#include <ann_init.h>
#include <ann_term.h>
#include <ann_factory.h>
#include <ann_parser_log.h>

namespace ANN
{
  class NE;
}

#include <ann_log.h>
#include <ann_weight.h>

namespace ANN
{

  //          //
 // class NE //
//          //

  class NE
  {
  public:
    typedef Log         Common_t;
    typedef const Init *Instance_t;
    typedef NE          Base_t;
    
    enum Status
    {
      done,    // training or computations successfully completed
      wrong,   // training or computations impossible using provided data
      not_yet, // training not completed yet, but some progress possible
      never,   // not trained but cannot help it
      dumb     // no information about training progress avalable
    };

  private:
    NE();
    NE(const NE &that);

  protected:
    const char        *label;
    Size               in_size;
    Log               *log;
    static const Size  single_out_size;
    
    NE(Size in_size_, Log &log_, const char *label_=0);
    NE(Size in_size_, Log *log_, const char *label_=0);
    NE(Size in_size_, const char *label_=0);
    NE(Log &log_, Instance_t inst)
    : label(inst->dup_label()), in_size(inst->size), log(&log_) {}
    NE(Log *log_, Instance_t inst)
    : label(inst->dup_label()), in_size(inst->size), log(log_) {}
    NE(Instance_t inst)
    : label(inst->dup_label()), in_size(inst->size), log(0) {}

  public:
    virtual ~NE();

    const Size           &get_in_sizes() const { return in_size; }
    size_t                get_in_size() const { return in_size.total_size(); }
    virtual const Size   &get_out_sizes() const;
    virtual size_t        get_out_size() const;

    /** output comutation **/
    virtual Status        feed(const Term &in, Term &out)=0;

    /** before training starts or after it stops **/
    virtual void          reset(bool prod=false);
    /* switch between training and production modes */
    virtual bool          load(Parser_log &parser, time_t begin=0,
                               time_t end=NAV_get(time_t));
    /* loads state information from a log, you should call reset() then */
    virtual void          store(Log &log_);
    /* stores state information to a log */
    virtual void          randomize();
    /* randomizes weights */

    /** trainig **/
    virtual Status        adapt_for(size_t epochs=1)=0;
    /* conducts training for no more than specified number of epochs */
    virtual size_t        get_epoch() const=0;
    /* reports current epoch */
  };

  typedef FB<NE,const Init *> NE_FB;

  NE::Status operator + (NE::Status s1, NE::Status s2);
  inline NE::Status operator + (NE::Status s1, bool s2)
  { return s1 + (s2 ? NE::done : NE::not_yet); }
  inline NE::Status operator - (NE::Status s1, bool s2)
  { return s1 + (s2 ? NE::never : NE::not_yet); }
  
} //namespace ANN

#endif /* __ANN_NE_H */
