/***************************************************************************
                          ann_ls_set.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_LS_SET_H
#define __ANN_LS_SET_H

#include <set>

#include <cmp_ptr.h>
#include <ann_log.h>

namespace ANN
{

  class LS_set;

  //              //
 // class LS_set //
//              //

  class LS_set : public LS
  {
  protected:
    typedef std::set<Log_rec *,CmpPtr> LogSet;
    typedef LogSet::iterator           Iterator;

    LogSet children;
    
  public:
    LS_set() {}
    virtual ~LS_set();

    virtual bool  attach(Log_rec &child);
    virtual bool  detach(Log_rec &child);
    virtual void  commence();
    virtual void  open(size_t epoch);
    virtual void  feed(size_t which_, const Loc *where_);
    virtual void  close(size_t epoch);
    virtual void  conclude(size_t epoch);
    virtual void  concluded(size_t epoch);
  };

} // namespace ANN

#endif /* __ANN_LS_SET_H */
