/***************************************************************************
                          ann_ds_out.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_DS_OUT_H
#define __ANN_DS_OUT_H

#include <ctype.h>

#include <ann_loc.h>
#include <ann_ds_rec.h>
#include <ann_ne.h>

namespace ANN
{

  class DS_out;     /* data source producing neural element outputs */

  //              //
 // class DS_out //
//              //

  class DS_out : public DS_rec
  {
  private:
    NE   *elem;
    TERM  out_data;

    DS_out();
    DS_out(const DS_out &that);

  public:
    virtual bool        act_on(NE *elem_);

    DS_out(DS &orig_) : DS_rec(orig_), elem(0) {}
    DS_out(DS &orig_, NE &elem_) : DS_rec(orig_), elem(0)
    { act_on(&elem_); }
    virtual ~DS_out();

    virtual const Size &get_sizes() const;
    virtual size_t      get_size() const;
    virtual Term       &term();
    virtual const Term &term() const;
    virtual bool        reset();
    virtual void        feed();
    virtual bool        seek(size_t term_);
    virtual bool        locate(const Loc &loc);
  };

} // namespace ANN

#endif /* __ANN_DS_OUT_H */
