/***************************************************************************
                          ann_ds.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_DS_H
#define __ANN_DS_H

#include <ctype.h>

#include <ann_loc.h>
#include <ann_term.h>
#include <ann_ts.h>

namespace ANN
{

  class DS; /* data source */

  //          //
 // class DS //
//          //

  class DS
  {
  private:
    DS(const DS &that);

  protected:

    DS() {}

    virtual bool  resize(const Size &sizes_);
    virtual bool  set_length(const Size &lengths_);
    virtual bool  set_limits(const Size &lengths_, const Size &sizes_);
    virtual TS   *all_terms();

  public:
    virtual ~DS();

    virtual const Size &get_lengths() const=0;    /* data sequence lengths */
    virtual size_t      get_length() const; /* oveall data sequence length */
    virtual const Size &get_sizes() const;  /* term sizes */
    virtual size_t      get_size() const;   /* overall term size */
    virtual Term       &term()=0;
    virtual const Term &term() const=0;
    /* data browsing events */
    virtual bool        reset()=0;
    virtual void        feed()=0;
    virtual bool        seek(size_t term_pos_);
    virtual bool        locate(const Loc &loc);
    /* reset()  -- if possible shifts data source back to the first term
     *             and returns true, otherwise calls feed() and returns false
     * feed()   -- shifts data source to the next term, if the last
     *             term was presented, first is presented again
     * seek()   -- shifts data source to the specified term in the
     *             permutation of terms, term positions in the
     *             permutation are constant between calls to reset()
     * locate() -- positions at the specified absolute location */
    virtual const Loc  &where() const=0;
    virtual size_t      which() const;
    /* position of the current term in the sequence, the number returned by
     * which() is the position of the term in the permutation of the data
     * source (if terms are permuted), while location returned by where()
     * is always absolute */
    virtual const TS   *all_terms() const;
    /* the above function returns a pointer to an array of all terms making up
     * the current training sequence, if such an array can not be provided by
     * the data source, zero is returned (default behavior), in this case feed()
     * reset() and seek() functions should be used */

    double &operator [] (size_t idx) { return term()[idx]; }
    double  operator [] (size_t idx) const { return term()[idx]; }
    double &operator [] (const Loc &loc) { return term()[loc]; }
    double  operator [] (const Loc &loc) const { return term()[loc]; }
    DS     &operator ++ () { feed(); return *this; }
  };

} // namespace ANN

#endif /* __ANN_DS_H */
