/***************************************************************************
                          ann_cybenko.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_CYBENKO_H
#define __ANN_CYBENKO_H

#include <ann_weight.h>
#include <ann_nfb_perc.h>
#include <ann_nfb_mlayer.h>

namespace ANN
{

  NFB_mlayer *
  create_Cybenko(Log *log, const char *label, size_t in, size_t hidden,
                 size_t out, W_FB &w, Act &act=Act::sigmoidal, bool bias=true);
  inline NFB_mlayer *
  create_Cybenko(Log *log, const char *label, size_t in, size_t hidden,
                 size_t out, W_FB &w, bool bias)
  { return create_Cybenko(log,label,in,hidden,out,w,Act::sigmoidal,bias); }
  inline NFB_mlayer *
  create_Cybenko(Log *log, size_t in, size_t hidden, size_t out, W_FB &w,
                 Act &act=Act::sigmoidal, bool bias=true)
  { return create_Cybenko(log,0,in,hidden,out,w,act,bias); }
  inline NFB_mlayer *
  create_Cybenko(Log *log, size_t in, size_t hidden, size_t out, W_FB &w,
                 bool bias)
  { return create_Cybenko(log,0,in,hidden,out,w,Act::sigmoidal,bias); }
  inline NFB_mlayer *
  create_Cybenko(const char *label, size_t in, size_t hidden, size_t out,
                 W_FB &w, Act &act=Act::sigmoidal, bool bias=true)
  { return create_Cybenko(0,label,in,hidden,out,w,act,bias); }
  inline NFB_mlayer *
  create_Cybenko(const char *label, size_t in, size_t hidden, size_t out,
                 W_FB &w, bool bias)
  { return create_Cybenko(0,label,in,hidden,out,w,Act::sigmoidal,bias); }
  inline NFB_mlayer *
  create_Cybenko(size_t in, size_t hidden, size_t out, W_FB &w,
                 Act &act=Act::sigmoidal, bool bias=true)
  { return create_Cybenko(0,0,in,hidden,out,w,act,bias); }
  inline NFB_mlayer *
  create_Cybenko(size_t in, size_t hidden, size_t out, W_FB &w, bool bias)
  { return create_Cybenko(0,0,in,hidden,out,w,Act::sigmoidal,bias); }

} //namespace ANN

#endif /* __ANN_CYBENKO_H */

