/***************************************************************************
                          xpm_frames.cpp  -  description
                             -------------------
    begin                : pon kwi 14 18:06:02 CEST 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <fstream>

#include <ann_log_io.h>
#include <ann_ds_frame.h>
#include <ann_ds_xpm.h>
#include <ann_sink_log.h>
#include <ann_sink_xpm.h>

#define INPUT_FILE    "input.xpm"
#define OUTPUT_PREFIX "output"

void
sample_frames(ANN::Log &log)
{
  /* open a file */
  std::ifstream is(INPUT_FILE);
  /* read it in as an XPM image */
  ANN::DS_xpm   ds_xpm(is);
  /* now we have in ds_xpm one single (but large) term, in most cases we need
   * it to be broken into a sequence of subframes before we present the image
   * to the network */
  ANN::DS_frame ds_frame(
    ds_xpm,                // what to break into frames
    (ANN::Size()<<15<<15), // every frame should be 15x15 (vert. x horiz.)
    (ANN::Size()<<2<<2)    // upper left corners of frames are located every
  );                       // 2 pixels vertically and 2 pixels horizontally
  /* At the moment I haven't networks to process images so I can only
   * show how to store a sequence of pictures into files */
  /* We need a sink to store data, in this cas in the XPM format */
  ANN::Sink_xpm sink_xpm(OUTPUT_PREFIX);
  /* Having a sink, we can use it */
  sink_xpm.store(ds_frame);
  /* We can also store the data to some log */
  ANN::Sink_log sink_log(log);
  sink_log.store(ds_frame,"output");
  /* We can also store there the original image */
  log.log(ds_xpm.term(),"input");
}

int
main(int argc, char *argv[])
{
  /* All the events will be logged to the terminal. If you want to store them
   * somwhere else, you need to redirect stdout. For example run the following
   * command:
   * $ ./ann >/some/file
   */
  ANN::Log_io log(std::cout);

  /*
   * Uncomment any of the following lines to activate samples You like
   * by deleting or puting a single space between an asterisk and a slash
   */

  /* there is a space between the asterisk and the slash, so the comment
   * encloses the following code
   * /
   int commented;  /**/

  /* there is no space beetween the asterisk and the slash, so the following
   * declaration is not enclosed in the comment and will be compiled
   */
   int uncommented; /**/

  /**/ /* slash asterisk asterisk slash is used to close any comment
        * not closed so far (after each code activating separate example)
  /**/

   //
  // start of calling sample routines
 //

  /* Example of loading XPM image, making a sequnce of subframes of it and
   * storing them in separate files. No neural computations, demonstration
   * of data handling capabilities only.
   */
  sample_frames(log); /**/

   //
  // end of calling sample routines
 //

  log.nl("Work finished.");
  return EXIT_SUCCESS;
}
