/***************************************************************************
                          ann_sink_xpm.cpp  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#if STDC_HEADERS
# include <stdlib.h>
# include <stddef.h>
#else
# if HAVE_STDLIB_H
#  include <stdlib.h>
# endif
#endif
#if HAVE_STRING_H
# if !STDC_HEADERS && HAVE_MEMORY_H
#  include <memory.h>
# endif
# include <string.h>
#endif
#if HAVE_STRINGS_H
# include <strings.h>
#endif
#if HAVE_LIMITS_H
#include <limits.h>
#endif

#include <fstream>

#include <ann_sink_xpm.h>

static void
mk_identifier(char *str, size_t len)
{
  char   c;
  size_t i;
  for (i=0; i<len; ++i)
  {
    c=str[i];
    if (((c<'a') || ('z'<c)) && ((c<'A') || ('Z'<c)) && (c!='_') &&
        ((c<'0') || ('9'<c) || !i)) str[i]='_';
  }
}

static bool
write_xpm(std::ostream &os, const char *label, const ANN::Term &term,
          double black, double delta)
{
  size_t         height=term.get_sizes()[0];
  size_t         width=term.get_sizes()[1];
  const double  *data=term.get_data();
  unsigned char  d1, d2;
  int            j1, j2;
  os << "/* XPM */" << std::endl
     << "static char *" << label << "[]={" << std::endl
     << '\"' << width << ' ' << height << " 256 2";
  for (j1=0; j1<16; ++j1) for (j2=0; j2<16; ++j2)
  {
    if ((d1=j1)<10) d1+='0'; else d1+='a'-10;
    if ((d2=j2)<10) d2+='0'; else d2+='a'-10;
    os <<  "\"," << std::endl
       << '\"' << char(j1 + 'a') << char(j2 + 'a') << " c #"
       << d1 << d2 << d1 << d2 << d1 << d2;
  }
  for (size_t h=0; h<height; ++h)
  {
    os << "\"," << std::endl
       << '\"';
    for(size_t w=0; w<width; ++w)
    {
      double pixel=*data++-black;
      if (pixel<0) pixel=0;
      else if (pixel>delta) pixel=255;
      else pixel*=255/delta;
      d2=int(rint(pixel));
      d1=(d2 >> 4)+'a';
      d2&=0xf;
      d2+='a';
      os << d1 << d2;
    }
  }
  os << "\"};" << std::endl;
  return os;  
}

  //                     //
 // class ANN::Sink_xpm //
//                     //

ANN::Sink_xpm::~Sink_xpm()
{
}

void
ANN::Sink_xpm::init_labels(const char *label_)
{
  const char *tmp;
  set_label(label_);
  if (!(tmp=strrchr(label.label(),'/'))) tmp=label.label();
  var.set_label(tmp);
  mk_identifier(var.label(),var_len=var.length());  
}

bool
ANN::Sink_xpm::open(Size lengths, Size sizes)
{
  return (sizes.dim()==2) && sizes.total_size();
}

bool
ANN::Sink_xpm::feed(size_t which_, const Loc &where_, const Term &in,
                    const char *label_)
{
  if ((in.get_sizes().dim()!=2) || !in.get_size()) return false;
  size_t len_l, len_v=var.length();
  if (label_)
  {
    label.set_label(label_,lab_len,'_');
    len_l=label.length();
    var.set_label(label_,var_len,'_');
    len_v=var.length();
  }
  else
  {
    len_l=lab_len;
    len_v=var_len;
  }
  size_t i, n=where_.dim();
  for (i=0; i<n; ++i)
  {
    label.set_index(where_[i],len_l,'-',0);
    len_l=label.length();
    var.set_index(where_[i],len_v,'_',0);
    len_v=var.length();
  }
  label.set_label("xpm",len_l,'.');
  var.set_label("xpm",len_v,'_');
  std::ofstream os(label.label());
  return write_xpm(os,var.label(),in,black,delta);
}

bool
ANN::Sink_xpm::close()
{
  return true;
}
