/***************************************************************************
                          ann_sink.cpp  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include <ann_sink.h>

  //                 //
 // class ANN::Sink //
//                 //

ANN::Sink::~Sink()
{
}

bool
ANN::Sink::store(DS &data, const char *label_)
{
  bool pos_ok=data.reset();
  Size length(data.get_lengths());
  if (!length.total_size() || (length.total_size()==size_max)) return false;
  Loc  loc;
  bool ret=open(length,data.get_sizes());
  while (ret && length.next(loc))
  {
    if (!pos_ok) data.feed();
    pos_ok=data.locate(loc);
    ret=feed(data.which(),data.where(),data.term(),label_);
  }
  return close() && ret;
}
