/***************************************************************************
                          ann_nit_kohonen.cpp  -  description
                             -------------------
    begin                : sob wrz  6  2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include <ann_nit_kohonen.h>

  //                   //
 // class NIT_kohonen //
//                   //

ANN::NIT_kohonen::~NIT_kohonen()
{
}

void
ANN::NIT_kohonen::feed_back(const Term &in, const Term &out,
                            const Term *out_fb, Term *in_fb)
{
  size_t        i, n=out_size.total_size();
  size_t        j, m=in_size.total_size();
  const double *u, *x=in.get_data(), *X=out.get_data(), *E=out_fb->get_data();
  double       *d=w_grad.get_data(), *e, e_, E_;
  if (in_fb)
  {
    e=in_fb->get_data();
    for (j=0; j<m; ++j) e[j]=0;
  }
  for (i=0; i<n; ++i) if (E_=E[i])
  {
    u=w[i]->values().get_data();
    if (in_fb) e_=(X[i]-1)*E_;
    for (j=0; j<m; ++j)
    {
      if (in_fb) e[j]+=e_*u[j];
      d[j]=(x[j]-u[j])*E_;
    }  
    w[i]->feed_back(w_grad);
  }
}

