/***************************************************************************
                          ann_loc.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include <ann_loc.h>

  //                //
 // class ANN::Loc //
//                //

size_t         ANN::Loc::nav=ANN::size_max;
const ANN::Loc ANN::Loc::empty;

ANN::Loc::~Loc()
{
  if (cap) delete [] pos.coordinates;
}

size_t
ANN::Loc::get_dim(const size_t *coordinates_)
{
  size_t dimension_=0;
  if (coordinates_)
    while (coordinates_[dimension_]!=ANN::size_max) ++dimension_;
  return dimension_;
}

void
ANN::Loc::resize(size_t dimension_, const size_t *coordinates_, size_t value)
{
  size_t  i;
  size_t *coords=coord(), *tmp;
  if (dimension_<=dimension) tmp=coord();
  else if (dimension_>1) tmp=new size_t[dimension_];
  else tmp=&pos.coordinate;
  if (coordinates_) for (i=0; i<dimension_; ++i) tmp[i]=coordinates_[i];
  else 
  {
    size_t min=(dimension<dimension_ ? dimension : dimension_);
    if (tmp!=coords) for (i=0; i<min; ++i) tmp[i]=coords[i];
    for (i=min; i<dimension_; ++i) tmp[i]=value;
  }
  if ((tmp!=coords) && (tmp!=&pos.coordinate))
  {
    if (cap) delete [] pos.coordinates;
    pos.coordinates=tmp;
    cap=dimension_;
  }
  dimension=dimension_;
}

size_t
ANN::Loc::product() const
{
  size_t        i, prod=1;
  const size_t *coords=coord();
  for (i=0; i<dimension; ++i) switch (coords[i])
  {
  case 0:
    return 0;
  case size_max:
    while (++i<dimension) if (!coords[i]) return 0;
    return size_max;
  default:  
    prod*=coords[i];
  }  
  return prod;
}

ANN::Loc &
ANN::Loc::expand(const Loc &that)
{
  if (dimension<that.dim()) resize(that.dim(),0,0);
  size_t        i, *coords=coord();
  const size_t *that_coords=that.coord();
  for (i=0; i<that.dim(); ++i)
    if (coords[i]<that_coords[i]) coords[i]=that_coords[i];
  return *this;
}

ANN::Loc &
ANN::Loc::shrink(const Loc &that)
{
  if (dimension>that.dim()) resize(that.dim(),0,0);
  size_t        i, *coords=coord();
  const size_t *that_coords=that.coord();
  for (i=0; i<dimension; ++i)
    if (coords[i]>that_coords[i]) coords[i]=that_coords[i];
  return *this;
}

ANN::Loc &
ANN::Loc::shrink_back(const Loc &that)
{
  size_t i, n=that.dim(), *coords;
  if (!n)
  {
    resize();
    return *this;
  }
  if (dimension>n)
  {
    coords=coord();
    i=dimension-n;
    while (n)
    {
      coords[n+i]=coords[n];
      --n;
    }  
    resize(that.dim(),0,0);
  }
  coords=coord();
  n=that.dim()-dimension;
  const size_t *that_coords=that.coord();
  for (i=0; i<dimension; ++i)
    if (coords[i]>that_coords[i+n]) coords[i]=that_coords[i+n];
  return *this;
}

ANN::Loc &
ANN::Loc::append(size_t dim_, const size_t *coord_)
{
  size_t i, n, *my_coords_;
  if (n=dim_)
  {
    resize(dimension+n,0,*coord_);
    my_coords_=coord();
    for (i=n+1; i<dimension; ++i) my_coords_[i]=coord_[i-n];
  }
  return *this;
}

void
ANN::Loc::clear()
{
  size_t i, *coords=coord();
  for (i=0; i<dimension; ++i) coords[i]=0;
}

short
ANN::Loc::cmp(const ANN::Loc &that) const
{
  bool          dim_less=dimension<that.dim();
  size_t        i, l=(dim_less ? dimension : that.dim());
  const size_t *coords=coord(), *that_coords=that.coord();
  for (i=0; i<l; ++i) if (coords[i]!=that_coords[i])
    return coords[i]<that_coords[i] ? -1 : 1;
  return dim_less ? -1 : dimension<that.dim();
}

  //                 //
 // class ANN::Size //
//                 //

void
ANN::Size::resize(size_t dimension_, const size_t *coordinates_, size_t value)
{
  if ((dimension!=dimension_) || coordinates_)
  {
    Loc::resize(dimension_,coordinates_,value);
    reset();
  }  
}

ANN::Size &
ANN::Size::expand(const Loc &that)
{
  size_t        i, *coords, tmp;
  const size_t *that_coords=that.get_coord();
  bool          b_set=(total && (total!=size_max));
  if (dimension<that.dim()) Loc::resize(that.dim(),0,total!=0);
  coords=coord();
  for (i=0; i<that.dim(); ++i) if (coords[i]<(tmp=that_coords[i]+1))
  {
    if (b_set) 
    {
      total/=coords[i];
      total*=tmp;
    }
    coords[i]=tmp;
  }
  if (!total) reset();
  return *this;
}

ANN::Size &
ANN::Size::expand(const Size &that)
{
  size_t        i, *coords;
  const size_t *that_coords=that.coord();
  bool          b_reset=!total;
  if (dimension<that.dim()) Loc::resize(that.dim(),0,total!=0);
  coords=coord();
  for (i=0; i<that.dim(); ++i) if (coords[i]<that_coords[i])
  {
    if (total && (total!=size_max)) if (that_coords[i]==size_max)
      total=size_max;
    else
    {
      total/=coords[i];
      total*=that_coords[i];
    }
    coords[i]=that_coords[i];
  }
  if (b_reset) reset();
  return *this;
}

ANN::Size &
ANN::Size::shrink(const Size &that)
{
  Loc::shrink(that);
  reset();
  return *this;
}

ANN::Size &
ANN::Size::shrink_back(const Size &that)
{
  Loc::shrink_back(that);
  reset();
  return *this;
}

ANN::Size &
ANN::Size::append(size_t dim_, const size_t *coord_)
{
  if (dim_)
  {
    Loc::append(dim_,coord_);
    reset();
  }  
  return *this;
}

ANN::Size &
ANN::Size::append(const Size &that)
{
  if (that.dim())
  {
    bool degen=!dim();
    Loc::append(that.dim(),that.coord());
    switch (total)
    {
    case size_max:
      if (!that.total) total=0;
      break;
    case 0:
      if (degen) total=that.total;
      break;
    default:
      if (that.total==size_max) total=size_max;
      else total*=that.total;
    }
  }
  return *this;
}

size_t
ANN::Size::index(const Loc &loc) const
{
  size_t l_dim=loc.dim();
  if (l_dim>dimension) return size_max;
  size_t        i, idx=0, crdnt, limit;
  const size_t *coords=coord(), *loc_coords=loc.get_coord();
  for (i=0; i<l_dim; ++i)
  {
    crdnt=loc_coords[i];
    limit=coords[i];
    if ((limit<=crdnt) || (idx && (limit==size_max))) return size_max;
    (idx*=limit)+=crdnt;
  }
  while (i<dimension)
    if ((limit=coords[i])==size_max) return size_max; else idx*=coords[i++];
  return idx;
}

bool
ANN::Size::next(Loc &loc) const
{
  if (!total) return false;
  if (!loc.dim())
  {
    loc.resize(dimension);
    return true;
  }  
  if (loc.dim()!=dimension) return false;
  size_t        i=dimension, *loc_coords=loc.get_coord();
  const size_t *coords=coord();
  do
  {
    --i;
    if (++loc_coords[i]<coords[i]) return true;
    loc_coords[i]=0;
  }
  while (i>0);
  loc.resize();
  return false;
}

bool
ANN::Size::locate(size_t idx, Loc &loc) const
{
  if (!total) return false;
  loc.resize(dimension);
  size_t        i=dimension, *coords_=loc.get_coord();
  const size_t *coords=coord();
  while (i && idx)
  {
    if (coords[--i]==size_max) return false;
    coords_[i]=idx%coords[i];
    idx/=coords[i];
  }
  while (i) coords_[--i]=0;
  return true;
}

void
ANN::Size::reset()
{
  total=(dimension ? ANN::Loc::product() : 0);
}

void 
ANN::Size::set(size_t which_dim, size_t size_)
{
  size_t min, *coords;
  bool   b_reset=!dimension;
  if (dimension<=which_dim)
  {
    if ((min=dimension)<which_dim) total=0;
    Loc::resize(which_dim+1,0,dimension!=0);
  }
  coords=coord();
  if (coords[which_dim]) total/=coords[which_dim];
  else if (which_dim<=min) b_reset=true;
  coords[which_dim]=size_;
  if (b_reset) reset(); else total*=size_;
}
