/***************************************************************************
                          ann_eval_fmap.cpp  -  description
                             -------------------
    begin                : wto wrz  9 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include <ann_eval_fmap.h>

  //                      //
 // class ANN::Eval_fmap //
//                      //

ANN::Eval_fmap::Eval_fmap(NIT &ne_, double sigma_, double radius_, 
                          bool compact_, Log *log_, const char *label_)
: Eval_compet(ne_, compact_, log_, label_ ? label_ : "feature_map")
{
  set_out_size(sigma_, radius_);
}

ANN::Eval_fmap::Eval_fmap(NIT &ne_, double sigma_, double radius_, 
                          bool compact_, const char *label_)
: Eval_compet(ne_, compact_, label_ ? label_ : "feature_map") 
{
  set_out_size(sigma_, radius_);
}

ANN::Eval_fmap::Eval_fmap(NIT &ne_, Log *log_, const char *label_, 
                          double sigma_, double radius_, bool compact_)
: Eval_compet(ne_, compact_, log_, label_ ? label_ : "feature_map") 
{
}

ANN::Eval_fmap::Eval_fmap(NIT &ne_, const char *label_, double sigma_, 
                          double radius_, bool compact_)
: Eval_compet(ne_, compact_, label_ ? label_ : "feature_map") 
{
  set_out_size(sigma_, radius_);
}

ANN::Eval_fmap::Eval_fmap(NIT *ne_, double sigma_, double radius_, 
                          bool compact_, Log *log_, const char *label_)
: Eval_compet(ne_, compact_, log_, label_ ? label_ : "feature_map") 
{
  set_out_size(sigma_, radius_);
}

ANN::Eval_fmap::Eval_fmap(NIT *ne_, double sigma_, double radius_, 
                          bool compact_, const char *label_)
: Eval_compet(ne_, compact_, label_ ? label_ : "feature_map") 
{
  set_out_size(sigma_, radius_);
}

ANN::Eval_fmap::Eval_fmap(NIT *ne_, Log *log_, const char *label_, 
                          double sigma_, double radius_, bool compact_)
: Eval_compet(ne_, compact_, log_, label_ ? label_ : "feature_map") 
{
  set_out_size(sigma_, radius_);
}

ANN::Eval_fmap::Eval_fmap(NIT *ne_, const char *label_, double sigma_, 
                          double radius_, bool compact_)
: Eval_compet(ne_, compact_, label_ ? label_ : "feature_map") 
{
  set_out_size(sigma_, radius_);
}

ANN::Eval_fmap::Eval_fmap(Size in_size_, double sigma_, double radius_, 
                          bool compact_, Log *log_, const char *label_)
: Eval_compet(in_size_, compact_, log_, label_ ? label_ : "feature_map") 
{
  set_out_size(sigma_, radius_);
}

ANN::Eval_fmap::Eval_fmap(Size in_size_, double sigma_, double radius_, 
                          bool compact_, const char *label_)
: Eval_compet(in_size_, compact_, label_ ? label_ : "feature_map") 
{
  set_out_size(sigma_, radius_);
}

ANN::Eval_fmap::Eval_fmap(Size in_size_, Log *log_, const char *label_, 
                          double sigma_, double radius_, bool compact_)
: Eval_compet(in_size_, compact_, log_, label_ ? label_ : "feature_map") 
{
  set_out_size(sigma_, radius_);
}

ANN::Eval_fmap::Eval_fmap(Size in_size_, const char *label_, double sigma_, 
                          double radius_, bool compact_)
: Eval_compet(in_size_, compact_, label_ ? label_ : "feature_map") 
{
  set_out_size(sigma_, radius_);
}

ANN::Eval_fmap::Eval_fmap(EvalC_fmap &c, const Init *inst)
: Eval_compet(c,inst)
{
  set_out_size(c.sigma, c.radius);
}

ANN::Eval_fmap::~Eval_fmap()
{
}

void 
ANN::Eval_fmap::set_out_size(double sigma_, double radius_)
{
  if (!radius_) radius_=2*sigma_;
  const Size *s=&Eval::get_out_sizes();
  size_t      i, j=0, n=s->dim(), m=1+(unsigned)radius_, sq_sum;
  Size        bonds_size;
  double      sgm=-0.5/(sigma_*sigma_), r2=radius_*radius_;
  if (compact) out_size << n;
  else out_size=*s;
  for (i=0; i<n; ++i) bonds_size << m;
  bonds.resize(bonds_size);
  Loc loc, sq_sums(bonds_size);
  while (bonds_size.next(loc))
  {
    i=n;
    while (i) if (loc[--i])
    {
      sq_sum=sq_sums[i]+=2*loc[i]-1;
      while (++i<n) sq_sums[i]=sq_sum;
      break;
    }
    bonds[j++]=(sq_sum>r2 ? 0 : exp(sgm*sq_sum));
  }
}

const ANN::Size &
ANN::Eval_fmap::get_out_sizes() const
{
  return out_size;
}

size_t
ANN::Eval_fmap::get_out_size() const
{
  return out_size.total_size();
}

ANN::NE::Status
ANN::Eval_fmap::feed(const Term &in, Term &out)
{
  Status ret;
  if ((ret=find_max(in))!=done) return ret;
  double *y=out.get_data(), max_val;
  size_t i, n=out.get_size();;
  if (compact) 
  {
    Eval::get_out_sizes().locate(max_ind,max_loc);
    for (i=0; i<n; ++i) y[i]=max_loc[i];
  }
  else
  {
    for (i=0; i<max_ind; ++i) y[i]=0;
    y[max_ind]=1;
    for (i=max_ind+1; i<n; ++i) y[i]=0;
  }
  if (log) log->log(out,label);
  return done;
}

void
ANN::Eval_fmap::feed_back(const Term &in, const Term &out,
                          const Term *out_fb, Term *in_fb)
{
  Term       *grad_=(ne ? (ne->fb_accept(in_fb) ? &grad : 0) : in_fb);
  const Term *grad_c=grad_;
  if (grad_)
  {
    double *g=grad_->get_data();
    size_t  i, n=Eval::get_out_size();
    if (compact)
    {
      for (i=0; i<max_ind; ++i) g[i]=0;
      g[max_ind]=1;
      for (i=max_ind+1; i<n; ++i) g[i]=0;
    }
    else if (ne) grad_c=&out;
    else *grad_=out;
    if (ne) ne->feed_back(in,comp,grad_c,in_fb);
  }
}

