/***************************************************************************
                          ann_weight.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_WEIGHT_H
#define __ANN_WEIGHT_H

#include <ann_use_size_t.h>

namespace ANN
{

  class  W;   /* weight engine */
  class  WGC; /* weight group factory common data */
  class  WG;  /* weight group */
  class  WS;  /* weight store */
  
} // namespace ANN

#include <ann_init.h>
#include <ann_term.h>
#include <ann_log.h>
#include <ann_parser_log.h>
#include <ann_ne.h>
#include <ann_factory.h>

namespace ANN
{

  //         //
 // class W //
//         //

  class W
  {
  private:
    W();
    W(const W &that);
    
  protected:
    char *label;
    TERM  w;

  public:
    typedef void        Common_t;
    typedef const Init *Instance_t;
    typedef W           Base_t;

    W(const Init *inst)
    : label(inst->dup_label()), w(inst->size) {}
    virtual ~W();

    const Term   &values() const { return w; }
    const Size   &get_sizes() const { return w.get_sizes(); }
    const size_t  get_size() const { return w.get_size(); }
    const char   *get_label() const { return label; }
    virtual bool  has_label(const char *label_);
    virtual WG   *get_group() const;
    virtual void  reset(NE *ne);                           /* mode switches */
    virtual void  commence(NE &ne);            /* training period commences */
    virtual void  feed_back(const Term &d_)=0;    /* called during training */
    virtual void  commit(NE &ne)=0;                        /* updates value */
    virtual void  conclude(NE &ne);            /* training period concludes */
    virtual void  randomize();                          /* randomizes value */
    virtual bool  load(Parser_log &parser, time_t begin=0,
                       time_t end=NAV_get(time_t)); /* loads from a log */
    virtual void  store(Log &log);                  /* stores to a log */
  };

  typedef FB<W,const Init *>                W_FB;
  typedef Array<W *,W *,Manip_ptr_take<W> > Wa;
  typedef ARRAY<W *,W *,Manip_ptr_take<W> > WA;

  //           //
 // class WGC //
//           //

  class WGC
  {
  private:
    WGC();

  public:
    Log *log;

    WGC(Log &log_) : log(&log_) {}
    WGC(const WGC &that) : log(that.log) {}

    WGC &operator = (const WGC &that)
    { log=that.log; return *this; }
  };

  //          //
 // class WG //
//          //

  class WG
  {
  public:
    typedef W             W_t;
    typedef Log           Common_t;
    typedef W::Instance_t Instance_t;
    typedef WG            Base_t;

  private:
    WG(WG &that);

  protected:
    Log *log;

    WG(Log *log_=0) : log(log_) {}
    WG(Log &log_) : log(&log_) {}
    WG(Log &log_, Instance_t inst) : log(&log_) {}
    WG(WGC &c) : log(c.log) {}
    WG(WGC &c, Instance_t inst) : log(c.log) {}

    virtual bool signature_find(Parser_log &parser, time_t begin=0,
                                time_t end=NAV_get(time_t));
    virtual void signature_write(Log &log, W &w);

  public:
    virtual ~WG();

    virtual bool   has_label(const char *label_)=0;
    virtual void   reset(NE *ne);
    virtual void   reseted(NE *ne);
    virtual void   commence(NE &ne);
    virtual void   commenced(NE &ne);
    virtual void   commit(NE &ne);
    virtual void   commited(NE &ne);
    virtual void   conclude(NE &ne);
    virtual void   concluded(NE &ne);
    virtual double get_random();
    static double  def_random();
    virtual bool   load(Parser_log &parser, time_t begin=0,
                        time_t end=NAV_get(time_t)); /* loads from a log */
    virtual void   store(Log &log_);                  /* stores to a log */
    virtual void   store_weights(Log &log_);  /* stores weights to a log */
  };

  //          //
 // class WS //
//          //

  class WS
  {
  private:
    WS(const WS &that);

  protected:
    WS() {}

  public:
    virtual ~WS();
    static WS *create();

    virtual void register_weight(W &w)=0;
    virtual void erase_weights()=0;
    virtual void reset(NE *ne)=0;
    virtual void commence(NE &ne)=0;
    virtual void commit(NE &ne)=0;  
    virtual void conclude(NE &ne)=0;  
    virtual void randomize()=0;    
    virtual bool load(Parser_log &parser, time_t begin=0,
                      time_t end=NAV_get(time_t))=0; 
    virtual void store(Log &log)=0;                  
  };

} // namespace ANN

#endif /* __ANN_WEIGHT_H */
