/***************************************************************************
                          ann_w_triv.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_W_TRIV_H
#define __ANN_W_TRIV_H

#include <ann_weight.h>
#include <ann_wg_set.h>
#include <ann_wc.h>
#include <ann_w_member.h>

namespace ANN
{

  class W_triv;

  //               //
 // class WG_triv //
//               //

  typedef WG_set<W_triv,W::Instance_t> WG_triv;
  typedef FB<WG_triv>                  WG_triv_FB;
  typedef F<WG_triv>                   WG_triv_F;

  //              //
 // class W_triv //
//              //

  class W_triv : public W
  {
  private:
    W_triv();
    W_triv(const W_triv &);

  public:
    typedef WC<WG_triv>   Common_t;
    typedef W::Instance_t Instance_t;
    typedef W             Base_t;
    typedef WG_triv       WG_t;

    W_triv(Common_t &c, Instance_t inst) : W(inst) {}
    virtual ~W_triv();

    virtual void     feed_back(const Term &d_);
    virtual void     commit(NE &ne);
    virtual WG_triv &the_group() const=0;
  };

  typedef WC<WG_triv>          WC_triv;
  typedef F<W_member<W_triv> > W_triv_F;
  
} // namespace ANN

#endif /* __ANN_W_TRIV_H */
