/***************************************************************************
                          ann_w_norm.h  -  description
                             -------------------
    begin                : czw wrz  4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_W_NORM_H
#define __ANN_W_NORM_H

#include <ann_weight.h>
#include <ann_wg_set.h>
#include <ann_wc.h>
#include <ann_w_member.h>
#include <ann_w_step.h>

namespace ANN
{

  typedef WGC_step WGC_norm;
  typedef WG_step  WG_norm;
  
  class W_norm;

  typedef WG_step_FB WG_norm_FB;
  typedef WG_step_F  WG_norm_F;
  
  //              //
 // class W_norm //
//              //

  class W_norm : public W_step
  {
  private:
    W_norm();
    W_norm(const W_norm &);

  protected:
    void normalize();

  public:
    typedef WC<WG_norm>   Common_t;
    typedef W::Instance_t Instance_t;
    typedef W             Base_t;
    typedef WG_norm       WG_t;

    W_norm(Common_t &c, Instance_t inst) : W_step(c,inst) {}

    virtual void     commence(NE &ne);
    virtual void     commit(NE &ne);
  };
  
  typedef WC<WG_norm>          WC_norm;
  typedef F<W_member<W_norm> > W_norm_F;  

} // namespace ANN

#endif /* __ANN_W_NORM_H */
