/***************************************************************************
                          ann_w_delta.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_W_DELTA_H
#define __ANN_W_DELTA_H

#include <ann_weight.h>
#include <ann_wg_set.h>
#include <ann_wc.h>
#include <ann_w_member.h>

namespace ANN
{

  class W_delta;

  //                //
 // class WG_delta //
//                //

  typedef WG_set<W_delta,W::Instance_t> WG_delta;
  typedef FB<WG_delta>                  WG_delta_FB;
  typedef F<WG_delta>                   WG_delta_F;

  //               //
 // class W_delta //
//               //

  class W_delta : public W
  {
  private:
    W_delta();
    W_delta(const W_delta &);

  protected:
    TERM d;

  public:
    typedef WC<WG_delta>  Common_t;
    typedef W::Instance_t Instance_t;
    typedef W             Base_t;
    typedef WG_delta      WG_t;

    W_delta(Common_t &c, Instance_t inst) : W(inst), d(inst->size) {}
    virtual ~W_delta();

    virtual void      commence(NE &ne);
    virtual void      feed_back(const Term &d_);
    virtual void      commit(NE &ne);
    virtual WG_delta &the_group() const=0;
  };

  typedef WC<WG_delta>          WC_delta;
  typedef F<W_member<W_delta> > W_delta_F;
  
} // namespace ANN

#endif /* __ANN_W_DELTA_H */
