/***************************************************************************
                          ann_eval_fmap.h  -  description
                             -------------------
    begin                : wto wrz  9 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_EVAL_FMAP_H
#define __ANN_EVAL_FMAP_H

#include <ann_eval_compet.h>

#define SIGMA_HALF_BOND 0.849322

namespace ANN
{

  class EvalC_fmap;
  class Eval_fmap;
  
  //                  //
 // class EvalC_fmap //
//                  //

  class EvalC_fmap : public EvalC_compet
  {
  public:
    double sigma;
    double radius;
    
    EvalC_fmap(NIT_FB &f_, Log *log_, double sigma_=SIGMA_HALF_BOND, 
               double radius_=0, bool compact_=true) 
    : EvalC_compet(f_, log_, compact_), sigma(sigma_), radius(radius_) {}
    EvalC_fmap(NIT_FB &f_, double sigma_=SIGMA_HALF_BOND, 
               double radius_=0, bool compact_=true) 
    : EvalC_compet(f_, compact_), sigma(sigma_), radius(radius_) {}
    EvalC_fmap(NIT_FB *f_, Log *log_, double sigma_=SIGMA_HALF_BOND, 
               double radius_=0, bool compact_=true) 
    : EvalC_compet(f_, log_, compact_), sigma(sigma_), radius(radius_) {}
    EvalC_fmap(NIT_FB *f_, double sigma_=SIGMA_HALF_BOND, 
               double radius_=0, bool compact_=true) 
    : EvalC_compet(f_, compact_), sigma(sigma_), radius(radius_) {}
    EvalC_fmap(Log *log_, double sigma_=SIGMA_HALF_BOND, 
               double radius_=0, bool compact_=true) 
    : EvalC_compet(log_, compact_), sigma(sigma_), radius(radius_) {}
    EvalC_fmap(double sigma_=SIGMA_HALF_BOND, double radius_=0, 
               bool compact_=true) 
    : EvalC_compet(compact_), sigma(sigma_), radius(radius_) {}
    EvalC_fmap(const EvalC_fmap &that)
    : EvalC_compet(that), sigma(that.sigma), radius(that.radius) {}
  };

  //                 //
 // class Eval_fmap //
//                 //

  class Eval_fmap : public Eval_compet
  {
  public:
    typedef EvalC_fmap     Common_t;
    typedef NE::Instance_t Instance_t;
    typedef NIT            Base_t;

  private:
    Eval_fmap();
    Eval_fmap(const Eval_fmap &);

    void set_out_size(double sigma_, double radius_=0);

  protected:
    Size  out_size;
    Term  bonds;
    Loc   max_loc;
    
  public:
    Eval_fmap(NIT &ne_, double sigma_, double radius_, bool compact_, 
              Log *log_, const char *label_=0);
    Eval_fmap(NIT &ne_, double sigma_=SIGMA_HALF_BOND, double radius_=0, 
              bool compact_=true, const char *label_=0);
    Eval_fmap(NIT &ne_, Log *log_, const char *label_=0, 
              double sigma_=SIGMA_HALF_BOND, double radius_=0, 
              bool compact_=true);
    Eval_fmap(NIT &ne_, const char *label_=0, double sigma_=SIGMA_HALF_BOND, 
              double radius_=0, bool compact_=true);
    Eval_fmap(NIT *ne_, double sigma_, double radius_, bool compact_, Log *log_, 
              const char *label_=0);
    Eval_fmap(NIT *ne_, double sigma_=SIGMA_HALF_BOND, double radius_=0, 
              bool compact_=true, const char *label_=0);
    Eval_fmap(NIT *ne_, Log *log_, const char *label_=0, 
              double sigma_=SIGMA_HALF_BOND, double radius_=0, 
              bool compact_=true);
    Eval_fmap(NIT *ne_, const char *label_=0, double sigma_=SIGMA_HALF_BOND, 
              double radius_=0, bool compact_=true);
    Eval_fmap(Size in_size_, double sigma_, double radius_, bool compact_, 
              Log *log_, const char *label_=0);
    Eval_fmap(Size in_size_, double sigma_=SIGMA_HALF_BOND, 
              double radius_=0, bool compact_=true, const char *label_=0);
    Eval_fmap(Size in_size_, Log *log_, const char *label_=0, 
              double sigma_=SIGMA_HALF_BOND, double radius_=0, 
              bool compact_=true);
    Eval_fmap(Size in_size_, const char *label_=0, double sigma_=SIGMA_HALF_BOND, 
              double radius_=0, bool compact_=true);
    Eval_fmap(EvalC_fmap &c, const Init *inst);
    virtual ~Eval_fmap();

    virtual const Size &get_out_sizes() const;
    virtual size_t      get_out_size() const;
    virtual Status      feed(const Term &in, Term &out);
    
    virtual void        feed_back(const Term &in, const Term &out,
                                  const Term *out_fb, Term *in_fb);
  };
  
  typedef F<Eval_fmap> Eval_fmap_F;

} //namespace ANN

#endif /* __ANN_EVAL_FMAP_H */

