/***************************************************************************
                          ann_eval.h  -  description
                             -------------------
    begin                : czw wrz  4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_EVAL_H
#define __ANN_EVAL_H

#include <ann_to.h>

namespace ANN
{

  class EvalC;
  class Eval;

  //             //
 // class EvalC //
//             //

  class EvalC
  {
  public:
    NIT_FB *f;
    Log    *log;
    
    EvalC(NIT_FB &f_, Log *log_=0) : f(&f_), log(log_) {}
    EvalC(NIT_FB *f_, Log *log_=0) : f(f_), log(log_) {}
    EvalC(Log *log_=0) : f(0), log(log_) {}
    EvalC(const EvalC &that) : f(that.f), log(that.log) {}

    EvalC &operator = (const EvalC &that)
    {
      f=that.f;
      log=that.log;
      return *this;
    }    
  };

  //            //
 // class Eval //
//            //

  class Eval : public NIT
  {
  public:
    typedef EvalC          Common_t;
    typedef NE::Instance_t Instance_t;
    typedef NIT            Base_t;

  private:
    Eval();
    Eval(const Eval &that);

  protected:
    NIT    *ne;
    TERM    grad;

  public:
    Eval(NIT &ne_, Log *log_=0, const char *label_=0);
    Eval(NIT &ne_, const char *label_);
    Eval(NIT *ne_, Log *log_=0, const char *label_=0);
    Eval(NIT *ne_, const char *label_);
    Eval(Size in_size_, Log *log_=0, const char *label_=0);
    Eval(Size in_size_, const char *label_);
    Eval(Common_t &c, Instance_t inst);
    virtual ~Eval();

    virtual const Size   &get_out_sizes() const;
    virtual size_t        get_out_size() const;
    virtual Status        feed(const Term &in, Term &out);

    virtual void          register_weights(TO &school_);
    virtual void          reset(bool prod=false);
    virtual bool          load(Parser_log &parser, time_t begin=0,
                               time_t end=NAV_get(time_t));
    virtual void          store(Log &log_);
    virtual void          randomize();
    virtual Status        commence(DS &ds_, bool is_input);
    virtual void          conclude();
    virtual void          open();
    virtual Status        close();
  };

  typedef F<Eval> Eval_F;
  
} //namespace ANN

#endif /* __ANN_EVAL_H */
