/***************************************************************************
                          perc424.cpp  -  description
                             -------------------
    begin                : pon kwi 14 18:06:02 CEST 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <fstream>
#include <stdlib.h>

#include <ann_term.h>
#include <ann_parser_ws.h>
#include <ann_w_step.h>
#include <ann_w_mntm.h>
#include <ann_log_io.h>
#include <ann_log_lazy.h>
#include <ann_ds_tee.h>
#include <ann_ds_out.h>
#include <ann_ds_buff.h>
#include <ann_sink_ws.h>
#include <ann_sink_log.h>
#include <ann_ds_rnd.h>
#include <ann_eval_bprop.h>
#include <ann_nit_mlayer.h>
#include <ann_nit_perc.h>
#include <ann_to_offline.h>
#include <ann_to_online.h>
#include <ann_cybenko.h>

#define INPUT_FILE "test.txt"

void
sample_Cybenko(ANN::Log &log)
{
  size_t i;

  /*
   * creating lazy logs, that filter events and log them every N-th
   * epoch to the main log
   */
   
  ANN::Log_lazy lazy2(log,20); // the N is 20
  ANN::Log_lazy lazy3(log,30); // the N is 30
  ANN::Log_lazy lazy5(log,50); // the N is ... the N is ... YES!!! the N is 50

  /*
   * reading data in from file, then reporting them in the log
   */
   
  std::ifstream fdata(INPUT_FILE);
  ANN::Parser_ws parser;
  parser(fdata);
  ANN::DS_buff ds_in(parser.build(0));
  ANN::DS_buff ds_des_out(parser.build(1));
  if (ds_in.get_length()!=ANN::size_max) for (i=0; i<ds_in.get_length(); ++i)
  {
    log.log(ds_in.term(),"input  pattern");
    log.log(ds_des_out.term(),"output pattern");
    ds_in.feed();
    ds_des_out.feed();
  }
  
  /*
   * Preparation of a weight engine factory
   */
   
  /* 1. parameters of weight group */
  ANN::WGC_step   gr_wg_cmn
  (
    lazy5, // dump weight values to the log every 50 epochs
    1.0    // modify weights using 1.0 step (rather big, but the network is 
  );       // small - see further for the network structure)
  /* 2. weight group factory takes parameters for groups to be created */
  ANN::WG_step_F  gr_wg_f(gr_wg_cmn);
  /* 3. parameters for weights to be created - plain gradient weights
   * need to have appropriate weight group factory */
  ANN::WC_step    gr_w_cmn(gr_wg_f);
  /* 4. weight factory takes parameters for weights to be created */
  ANN::W_step_F   gr_w_f(gr_w_cmn);

  /*
   * now create an element evaluating other neural elements and supply
   * it with a brand new created Cybenko's network
   */
   
  ANN::Eval_bprop sample // declare evaluator
  (
    *ANN::create_Cybenko // create neural element to evluate
    (
      &lazy3,              // log outputs from neurons every 30 epochs
      "net_of_cybenko",    // name the element
      4,                   // 4 inputs
      2,                   // 2 hidden
      4,                   // 4 outputs
      gr_w_f,              // factory to create weights
      false                // the question is whether to use bias,
                           // the answer here is: false
    ),                   // otehr parameters of evaluator:
    ds_des_out,          // desired values -- for input sequence look into
                         // TO_offline constructor
    .01,                 // stop training when the error drops below .01
    &lazy2               // log effects of training every 20 epochs
  );

  /*
   * Training
   */

  /* create the trainer, give it pupil, data and a log to report */
  ANN::TO_offline trainer(sample,ds_in,&lazy5);
  /* randomize weights */
  trainer.randomize();
  /* train no more then 1000 epochs */
  trainer.adapt_for(1000);

  /*
   * Produce results
   */

  /* This DS forces neural element to produce outputs on inputs from some
   * other DS, produced outputs are data provided by this DS, desired output
   * co-sequence stays untouched */
  ANN::DS_out   ds_out(ds_in,sample);
  /* This sink stores data in a given log */
  ANN::Sink_log sink_log(log);
  /* Data goes through this DS unmodified, its role is to store it in a sink,
   * thus the name of the DS class comes from T-connectors (tee-connectors) */
  ANN::DS_tee   ds_tee
  (
    ds_out,   // source of the data
    sink_log, // where to dump copies
    "output"  // tag for main sequence
  );
  /* I cannot imagine any serios work without initial reset, reboot, reload
   * or something */
  ds_tee.reset();
  /* If the sequence is finited ... */
  if (ds_tee.get_length()!=ANN::size_max)
    for (i=1; i<ds_tee.get_length(); ++i) ds_tee.feed();
      /* ... walk through it, forcing it to produce outputs of the given neural
       * element (DS_out) and then dump these outputs to the log (DS_tee) */
}

void
sample_codec424(ANN::Log &log)
{
  size_t        i;

  /*
   * creating lazy logs, that filter events and log them every N-th
   * epoch to the main log
   */

  ANN::Log_lazy lazy2(log,20); // the N is 20
  ANN::Log_lazy lazy3(log,30);
  ANN::Log_lazy lazy5(log,50);

  /*
   * reading data in from file, then reporting them in the log
   */

  std::ifstream fdata(INPUT_FILE);
  ANN::Parser_ws parser;
  parser(fdata);
  ANN::DS_buff ds_in(parser.build(0));
  ANN::DS_buff ds_des_out(parser.build(1));
  if (ds_in.get_length()!=ANN::size_max) for (i=0; i<ds_in.get_length(); ++i)
  {
    log.log(ds_in.term(),"input  pattern");
    log.log(ds_des_out.term(),"output pattern");
    ds_in.feed();
    ds_des_out.feed();
  }

  /*
   * Preparation of a weight engine factory
   */

  /* 1. parameters of weight group */
  ANN::WGC_step    gr_wg_cmn
  (
    lazy5, // dump weight values to the log every 50 epochs
    10.0   // modify weights using 10.0 step (very fast, but the network is
  );       // small, problem not so complex - see further for the network
           // structure)
  /* 2. weight group factory takes parameters for groups to be created */
  ANN::WG_step_F   gr_wg_f(gr_wg_cmn);
  /* 3. parameters for weights to be created - plain gradient weights
   * need to have appropriate weight group factory */
  ANN::WC_step     gr_w_cmn(gr_wg_f);
  /* 4. weight factory takes parameters for weights to be created */
  ANN::W_step_F    gr_w_f(gr_w_cmn);

  /*
   * Network creation
   */

  /* Initial data for multilayer perceptron: number of inputs and a label
   * labels for the layers will be derived from the given label */
  ANN::Init        inst(4,"codec424_net");
  /* Parameters for the first (and the only) hidden layer */
  ANN::NITC_perc   hid_par
  (
    2,                   // number of neurons in the layer
    &lazy3,              // where to log outputs from neurons
    &gr_w_f,             // where to take weights from
    ANN::Act::sigmoidal, // activation function
    true                 // expand input to this layer by a bias neuron
  );                     // bias neurons are never implemented as separate
                         // objects
  /* Parameters for the last - output layer, see above for explanations*/
  ANN::NITC_perc  out_par(4,&lazy3,&gr_w_f,ANN::Act::sigmoidal,true);
  /* Prepare array of layer factories */
  ANN::NIT_perc_F *factory[]=
  {
    new ANN::NIT_perc_F(hid_par),
    new ANN::NIT_perc_F(out_par),
  };
  /* Create element evaluating outputs from multilayer network, supply
   * it with a brand new created multilayer network */
  ANN::Eval_bprop sample
  (
    *new ANN::NIT_mlayer // first we create an elemnt to be evaluated
    (                   // here it is a multilayer network
      &inst,    // initial data
      log,      // where to report important events
      factory,  // how to create layers - pointer to an array of factories
      factory+2 // how long is the array
    ),          // other paramters of evaluator
    ds_des_out, // desired output values to be tought
    .01,        // when errors drops below 0.01 assume the network is trained
    &lazy2      // log to report training progress
  );
  /* When the neural elements are created we need the factories no more */
  ANN::NIT_mlayer::drop_f(factory,factory+2);

  /*
   * Training
   */

  /* create the trainer, give it pupil, data and a log to report */
  ANN::TO_offline trainer(sample,ds_in,&lazy5);
  /* randomize weights */
  trainer.randomize();
  /* train no more then 1000 epochs */
  trainer.adapt_for(1000);

  /*
   * Produce results
   */

  /* This DS forces neural element to produce outputs on inputs from some
   * other DS, produced outputs are data provided by this DS, desired output
   * co-sequence stays untouched */
  ANN::DS_out   ds_out(ds_in,sample);
  /* This sink stores data in a given log */
  ANN::Sink_log sink_log(log);
  /* Store data from a given DS (in this case DS_out forces some neural element
   * to produce outputs, so the outputs from that element are stored) using
   * given tags for main sequence and co-sequence with desired outputs */
  sink_log.store(ds_out,"output");
}

void
sample_codec424_mntm(ANN::Log &log)
{
  /*
   * For comments see above, only first used elements are explained
   */

  size_t        i;
  ANN::Log_lazy lazy2(log,20);
  ANN::Log_lazy lazy3(log,30);
  ANN::Log_lazy lazy5(log,50);
  std::ifstream fdata(INPUT_FILE);
  ANN::Parser_ws parser;
  parser(fdata);
  ANN::DS_buff ds_in(parser.build(0));
  ANN::DS_buff ds_des_out(parser.build(1));
  if (ds_in.get_length()!=ANN::size_max) for (i=0; i<ds_in.get_length(); ++i)
  {
    log.log(ds_in.term(),"input  pattern");
    log.log(ds_des_out.term(),"output pattern");
    ds_in.feed();
    ds_des_out.feed();
  }

  /*
   * Preparation of momentum weight engine factory
   */

  /* 1. parameters of weight group */
  ANN::WGC_mntm    gr_wg_cmn(
    lazy5, // dump weight values to the log every 50 epochs
    .3,    // gradient step coeficient, call it etha
    .9     // momentum coeficient, call it alpha
  );
  /* Momentum formula is:
   * delta   = etha * ( - gradient ) + alpha * delta ;
   * weight += delta ;
   */
  /* 2. weight group factory takes parameters for groups to be created */
  ANN::WG_mntm_F   gr_wg_f(gr_wg_cmn);
  /* 3. parameters for weights to be created - momentum gradient weights
   * need to have appropriate weight group factory */
  ANN::WC_mntm     gr_w_cmn(gr_wg_f);
  /* 4. weight factory takes parameters for weights to be created */
  ANN::W_mntm_F    gr_w_f(gr_w_cmn);

  ANN::Init        inst(4,"codec424_net");
  ANN::NITC_perc   hid_par(2,&lazy3,&gr_w_f,ANN::Act::sigmoidal,true);
  ANN::NITC_perc   out_par(4,&lazy3,&gr_w_f,ANN::Act::sigmoidal,true);
  ANN::NIT_perc_F *factory[]=
  {
    new ANN::NIT_perc_F(hid_par),
    new ANN::NIT_perc_F(out_par),
  };
  ANN::Eval_bprop  sample(*new ANN::NIT_mlayer(&inst,log,factory,factory+2),
                         ds_des_out,.01,&lazy2);
  ANN::NIT_mlayer::drop_f(factory,factory+2);
  ANN::TO_offline trainer(sample,ds_in,&lazy5);
  trainer.randomize();
  trainer.adapt_for(1000);

  ANN::DS_out   ds_out(ds_in,sample);
  ANN::Sink_log sink_log(log);
  ANN::DS_tee   ds_tee(ds_out,sink_log);
  ds_tee.reset();
  if (ds_tee.get_length()!=ANN::size_max)
    for (i=1; i<ds_tee.get_length(); ++i) ds_tee.feed();
}

void
sample_codec424_mntm_rnd(ANN::Log &log)
{
  /*
   * For comments see above, only first used elements are explained
   */

  size_t        i;
  ANN::Log_lazy lazy2(log,20);
  ANN::Log_lazy lazy3(log,30);
  ANN::Log_lazy lazy5(log,50);
  std::ifstream fdata(INPUT_FILE);
  ANN::Parser_ws parser;
  parser(fdata);
  ANN::DS_buff ds_in(parser.build(0));
  ANN::DS_buff ds_des_out(parser.build(1));
  if (ds_in.get_length()!=ANN::size_max) for (i=0; i<ds_in.get_length(); ++i)
  {
    log.log(ds_in.term(),"input  pattern");
    log.log(ds_des_out.term(),"output pattern");
    ds_in.feed();
    ds_des_out.feed();
  }
  ANN::WGC_mntm    gr_wg_cmn(lazy5,.3,.9);
  ANN::WG_mntm_F   gr_wg_f(gr_wg_cmn);
  ANN::WC_mntm     gr_w_cmn(gr_wg_f);
  ANN::W_mntm_F    gr_w_f(gr_w_cmn);
  ANN::Init        inst(4,"codec424_net");
  ANN::NITC_perc   hid_par(2,&lazy3,&gr_w_f,ANN::Act::sigmoidal,true);
  ANN::NITC_perc   out_par(4,&lazy3,&gr_w_f,ANN::Act::sigmoidal,true);
  ANN::NIT_perc_F *factory[]=
  {
    new ANN::NIT_perc_F(hid_par),
    new ANN::NIT_perc_F(out_par),
  };
  ANN::Eval_bprop  sample(*new ANN::NIT_mlayer(&inst,log,factory,factory+2),
                         ds_des_out,.01,&lazy2);
  ANN::NIT_mlayer::drop_f(factory,factory+2);

  
  /*
   * Training
   */

  /* Once we want to teach online, data should be randomly reordered every
   * epoch, thus we don't use the the original DS but rather a DS that
   * permutes the data */
  ANN::DS_rnd     ds_rnd(ds_in);
  /* create the trainer, give it pupil, data and a log to report */
  ANN::TO_online trainer(sample,ds_rnd,&lazy5);
  /* randomize weights */
  trainer.randomize();
  /* train no more then 1000 epochs */
  trainer.adapt_for(1000);

    
  ANN::DS_out   ds_out(ds_in,sample);
  std::ofstream fout("wyniki.out");
  ANN::Sink_ws  sink_ws(fout);
  sink_ws.store(ds_out);
}

int
main(int argc, char *argv[])
{
  /* All the events will be logged to the terminal. If you want to store them
   * somwhere else, you need to redirect stdout. For example run the following
   * command:
   * $ ./ann >/some/file
   */
  ANN::Log_io log(std::cout);

  /*
   * Uncomment any of the following lines to activate samples You like
   * by deleting or puting a single space between an asterisk and a slash
   */

  /* there is a space between the asterisk and the slash, so the comment
   * encloses the following code
   * /
   int commented;  /**/

  /* there is no space beetween the asterisk and the slash, so the following
   * declaration is not enclosed in the comment and will be compiled
   */
   int uncommented; /**/

  /**/ /* slash asterisk asterisk slash is used to close any comment
        * not closed so far (after each code activating separate example)
  /**/

   //
  // start of calling sample routines
 //

  /* Backpropagation trained network of sigmoidal hidden and linear output 
   * neurons.
   * / 
  sample_Cybenko(log); /**/
  
  /* Backpropagation trained network of 2 sigmoidal hidden and 4 sigmoidal 
   * output neurons. The network has 4 inputs. Weights are updated offline
   * using plain gradient method.
   */
  sample_codec424(log); /**/
  
  /* Backpropagation trained network of 2 sigmoidal hidden and 4 sigmoidal
   * output neurons. The network has 4 inputs. Weights are updated offline
   * using momentum gradient method.
   * /
  sample_codec424_mntm(log); /**/
  
  /* Backpropagation trained network of 2 sigmoidal hidden and 4 sigmoidal
   * output neurons. The network has 4 inputs. Weights are updated online
   * using momentum gradient method. Input patterns are permuted every epoch.
   * /
  sample_codec424_mntm_rnd(log); /**/

   //
  // end of calling sample routines
 //

  log.nl("Work finished.");
  return EXIT_SUCCESS;
}
