/***************************************************************************
                          ann_w_mntm.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include <ann_w_mntm.h>

  //                    //
 // class ANN::WG_mntm //
//                    //

double
ANN::WG_mntm::get_random()
{
  return (2.0*rand())/RAND_MAX-1;
}

  //              //
 // class W_mntm //
//              //

ANN::W_mntm::~W_mntm()
{
}

void
ANN::W_mntm::reset(NE *ne)
{
  size_t i, l=delta.get_size();
  for (i=0; i<l; ++i) delta.get_data()[i]=0;
}

void
ANN::W_mntm::commence(NE &ne)
{
  size_t i, l=d.get_size();
  for (i=0; i<l; ++i) d.get_data()[i]=0;
}

void
ANN::W_mntm::feed_back(const Term &d_)
{
  size_t i, l=d.get_size();
  for (i=0; i<l; ++i) d.get_data()[i]+=d_.get_data()[i];
}

void
ANN::W_mntm::commit(NE &ne)
{
  size_t i, l=w.get_size();
  double etha=the_group().etha;
  double alpha=the_group().alpha;
  for (i=0; i<l; ++i)
  {
    delta.get_data()[i]*=alpha;
    delta.get_data()[i]+=etha*d.get_data()[i];
    w.get_data()[i]+=delta.get_data()[i];
    d.get_data()[i]=0;
  }
}

