/***************************************************************************
                          ann_time.cpp  -  description
                             -------------------
    begin                : pi kwi 18 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#if defined (HAVE_LOCALTIME_R) || defined (HAVE_GMTIME_R)
# define _REENTRANT
#endif

#include <stdio.h>
#if HAVE_STRING_H
# if !STDC_HEADERS && HAVE_MEMORY_H
#  include <memory.h>
# endif
# include <string.h>
#endif
#if HAVE_STRINGS_H
# include <strings.h>
#endif

#include <math.h>
#include <stdlib.h>

#include <ann_time.h>

#ifndef HAVE_TIMEGM

#define MONTH_DAYS_MAR 31
#define MONTH_DAYS_APR 30
#define MONTH_DAYS_MAY 31
#define MONTH_DAYS_JUN 30
#define MONTH_DAYS_JUL 31
#define MONTH_DAYS_AUG 31
#define MONTH_DAYS_SEP 30
#define MONTH_DAYS_OCT 31
#define MONTH_DAYS_NOV 30
#define MONTH_DAYS_DEC 31
#define MONTH_DAYS_JAN 31
#define MONTH_START_MAR 0
#define MONTH_START_APR MONTH_START_MAR + MONTH_DAYS_MAR
#define MONTH_START_MAY MONTH_START_APR + MONTH_DAYS_APR
#define MONTH_START_JUN MONTH_START_MAY + MONTH_DAYS_MAY
#define MONTH_START_JUL MONTH_START_JUN + MONTH_DAYS_JUN
#define MONTH_START_AUG MONTH_START_JUL + MONTH_DAYS_JUL
#define MONTH_START_SEP MONTH_START_AUG + MONTH_DAYS_AUG
#define MONTH_START_OCT MONTH_START_SEP + MONTH_DAYS_SEP
#define MONTH_START_NOV MONTH_START_OCT + MONTH_DAYS_OCT
#define MONTH_START_DEC MONTH_START_NOV + MONTH_DAYS_NOV
#define MONTH_START_JAN MONTH_START_DEC + MONTH_DAYS_DEC
#define MONTH_START_FEB MONTH_START_JAN + MONTH_DAYS_JAN

/*
 * This is calendar algorithm assumes for simplicity we have Gregorian Era
 */

static time_t
timegm(struct tm *t)
{
  static int m2d [] =
  {
    MONTH_START_JAN, MONTH_START_FEB, MONTH_START_MAR, MONTH_START_APR,
    MONTH_START_MAY, MONTH_START_JUN, MONTH_START_JUL, MONTH_START_AUG,
    MONTH_START_SEP, MONTH_START_OCT, MONTH_START_NOV, MONTH_START_DEC
  };
  int year, month, day=-719469;
  if (t->tm_mon<2)
  {
    year=t->tm_year+1899;
    month=t->tm_mon+12;
  }
  else
  {
    year=t->tm_year+1900;
    month=t->tm_mon;
  }
  day+=year*365+year/4-year/100+year/400;
  day+=m2d[month%12];
  day+=t->tm_mday;
  return ((day*24+t->tm_hour)*60+t->tm_min)*60+t->tm_sec;
}

#endif

struct tz_data
{
  signed char sign;
  int         hour;
  int         min;
};

static void
break_time(time_t t, struct tm &tm, struct tz_data &tz)
{
  struct tm *p_tm;
#ifdef HAVE_LOCALTIME_R
  localtime_r(&t,&tm);
#else
  p_tm=localtime(&t);
  tm.tm_year=p_tm->tm_year;
  tm.tm_mon=p_tm->tm_mon;
  tm.tm_mday=p_tm->tm_mday;
  tm.tm_hour=p_tm->tm_hour;
  tm.tm_min=p_tm->tm_min;
  tm.tm_sec=p_tm->tm_sec;
#endif
/* using mktime in UTC zone to find timezone offset
 */
  char *tz_str=getenv("TZ");
  setenv("TZ", "", 1);
  tzset();
  int diff=mktime(&tm)-t;
  if (tz_str) setenv("TZ", tz_str, 1); else unsetenv("TZ");
  tzset();
  tz.hour=diff/3600;
  tz.min=abs(diff/60-tz.hour*60);
  tz.hour=abs(tz.hour);
  tz.sign=(diff<0 ? '-' : '+');
/**/
/* using gmtime_r to calculate timezone offset
 * /
#ifdef HAVE_GMTIME_R
  struct tm temp;
  gmtime_r(&t,p_tm=&temp);
#else
  p_tm=gmtime(&t);
#endif
  tz.hour=tm.tm_hour-p_tm->tm_hour;
  tz.min=tm.tm_min-p_tm->tm_min;
  if (tz.min<0) 
  {
    tz.min+=60;
    --tz.hour;
  }
  if (tz.hour>=12) tz.hour-=24;
  else if (tz.hour<12) tz.hour+=24
  if (tz.hour<0)
  {
    if (tz.min>0)
    {
      tz.min-=60;
      ++tz.hour;
    }
    tz.sign='-';
    tz.hour=-tz.hour;
    tz.min=-tz.min;
  }
  else tz.sign='+';
  /**/
}

  //                 //
 // class ANN::Time //
//                 //

ANN::Time::Buffer &
ANN::Time::Buffer::operator = (const Buffer &that)
{
  resize(that.length);
  strcpy(buffer,that.buffer);
  return *this;
}

ANN::Time ANN::Time::format;

ANN::Time::Time()
{
#ifdef HAVE_TZSET
  static bool tz_was_not_set=true;
  if (tz_was_not_set)
  {
    tz_was_not_set=false;
    tzset();
  }
#endif
}

ANN::Time::~Time()
{
}

size_t
ANN::Time::stamp(Buffer &buff)
{
  static const char   frm[] = "%04d.%02d.%02d %02d:%02d:%02d %c%02d%02d";
  //field sizes (date)+(time)+timezone+separators: (4+2+2)+(2+2+2)+5+6 = 25
  static const size_t len=(4+2+2)+(2+2+2)+5+6;
  struct tm           tm;
  struct tz_data      tz;
  buff.resize(len);
  break_time(time(0),tm,tz);
  sprintf(buff.c_str(),frm,tm.tm_year+1900,tm.tm_mon+1,tm.tm_mday,
          tm.tm_hour,tm.tm_min,tm.tm_sec,tz.sign,tz.hour,tz.min);
  return len;
}

time_t
ANN::Time::parse(const Buffer &buff)
{
  if (!buff.c_str()) return NAV_get(time_t);
  struct tm      t;
  struct tz_data tz;
  t.tm_isdst=0;
  if (sscanf(buff.c_str(),"%u.%u.%u %u:%u:%u %c%2u%2u",
             &t.tm_year,&t.tm_mon,&t.tm_mday,
             &t.tm_hour,&t.tm_min,&t.tm_sec,
             &tz.sign,&tz.hour,&tz.min)!=9)
    return NAV_get(time_t);
  switch(tz.sign)
  {
  case '-':
    tz.sign=-60;
    break;
  case '+':
    tz.sign=60;
    break;
  default:
    return NAV_get(time_t);
  }
  return timegm(&t)+(tz.hour*60+tz.min)*tz.sign;
}

  //                      //
 // class ANN::Time_unix //
//                      //

ANN::Time_unix ANN::Time_unix::format;

ANN::Time_unix::~Time_unix()
{
}

size_t
ANN::Time_unix::stamp(Buffer &buff)
{
  buff.resize(sizeof(long)*3);
  long t(time(0));
  sprintf(buff.c_str(),"%ld",t);
  return strlen(buff.c_str());
}

time_t
ANN::Time_unix::parse(const Buffer &buff)
{
  if (!buff.c_str()) return NAV_get(time_t);
  long t;
  if (sscanf(buff.c_str(),"%ld",&t)!=1) return NAV_get(time_t);
  return time_t(t);
}

