/***************************************************************************
                          ann_nit_perc.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include <ann_nit_perc.h>

  //                //
 // class NIT_perc //
//                //

ANN::NIT_perc::NIT_perc(NITC_perc &c, const Init *inst)
: NIT_linear(c,inst), act(c.act), sum(c.out_size), sum_grad(c.out_size)
{
  Label lab(label);
  lab.set_label("act",lab.length());
  label_act=lab.dup_label();
}

ANN::NIT_perc::~NIT_perc()
{
  if (label_act) delete [] label_act;
}

ANN::NE::Status
ANN::NIT_perc::feed(const Term &in, Term &out)
{
  Status  ret;
  if ((ret=NIT_linear::feed(in,sum))!=done) return ret;
  size_t  i, n=out_size.total_size();
  double *X=sum.get_data(), *y=out.get_data();
  for (i=0; i<n; ++i) y[i]=(*act)(X[i],y[i]);
  if (label_act && log && log->is_active()) log->log(out,label_act);
  return done;
}

void
ANN::NIT_perc::feed_back(const Term &in, const Term &out,
                         const Term *out_fb, Term *in_fb)
{
  size_t        i, n=out_size.total_size();
  const double *y=out.get_data(), *e=out_fb->get_data();
  double       *X=sum.get_data(), *E=sum_grad.get_data();
  for (i=0; i<n; ++i) E[i]=(*act)(X[i],y[i],E[i])*e[i];
  NIT_linear::feed_back(in,sum,&sum_grad,in_fb);
}

