/***************************************************************************
                          ann_eval.cpp  -  description
                             -------------------
    begin                : czw wrz  4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include <ann_eval.h>

  //                 //
 // class ANN::Eval //
//                 //

ANN::Eval::Eval(NIT &ne_, Log *log_, const char *label_)
: NIT(ne_.get_in_sizes(), log_, label_ ? label_ : "evaluator"), ne(&ne_)
{
  if (ne && ne->fb_accept(true)) grad.resize(ne->get_out_sizes());
}

ANN::Eval::Eval(NIT &ne_, const char *label_)
: NIT(ne_.get_in_sizes(), label_ ? label_ : "evaluator"), ne(&ne_)
{
  if (ne && ne->fb_accept(true)) grad.resize(ne->get_out_sizes());
}

ANN::Eval::Eval(NIT *ne_, Log *log_, const char *label_)
: NIT(ne_->get_in_sizes(), log_, label_ ? label_ : "evaluator"), ne(ne_)
{
  if (ne && ne->fb_accept(true)) grad.resize(ne->get_out_sizes());
}

ANN::Eval::Eval(NIT *ne_, const char *label_)
: NIT(ne_->get_in_sizes(), label_ ? label_ : "evaluator"), ne(ne_)
{
  if (ne && ne->fb_accept(true)) grad.resize(ne->get_out_sizes());
}

ANN::Eval::Eval(Size in_size_, Log *log_, const char *label_)
: NIT(in_size_, log_, label_ ? label_ : "evaluator"), ne(0)
{
}

ANN::Eval::Eval(Size in_size_, const char *label_)
: NIT(in_size_, label_ ? label_ : "evaluator"), ne(0)
{
}

ANN::Eval::Eval(Common_t &c, Instance_t inst_)
: NIT(*c.log,inst_), ne(0)
{
  if (c.f) 
  {
    Init inst(inst_);
    inst.set_label("trainee",inst.length());
    ne=c.f->create(&inst);
  }
  if (ne && ne->fb_accept(true)) grad.resize(ne->get_out_sizes());
}

ANN::Eval::~Eval()
{
  if (ne) delete ne;
}

const ANN::Size &
ANN::Eval::get_out_sizes() const
{
  return ne ? ne->get_out_sizes() : get_in_sizes();
}

size_t
ANN::Eval::get_out_size() const
{
  return ne ? ne->get_out_size() : get_in_size();
}

ANN::NE::Status
ANN::Eval::feed(const Term &in, Term &out)
{
  if (ne) return ne->feed(in,out);
  out=in;
  return done;
}

void
ANN::Eval::register_weights(TO &torg_)
{
  NIT::register_weights(torg_);
  if (ne) ne->register_weights(torg_);
}

void
ANN::Eval::reset(bool prod)
{
  if (ne) ne->reset(prod);  
}

bool
ANN::Eval::load(Parser_log &parser, time_t begin, time_t end)
{
  return !ne || ne->load(parser,begin,end);
}

void
ANN::Eval::store(Log &log_)
{
  if (ne) ne->store(log_);
}

void
ANN::Eval::randomize()
{
  if (ne) ne->randomize();
}

ANN::NE::Status
ANN::Eval::commence(DS &ds_, bool is_input)
{
  Status ret;
  if ((ret=NIT::commence(ds_,is_input))==wrong) return ret;
  return ne ? ne->commence(ds_,is_input) : done;
}

void
ANN::Eval::conclude()
{
  if (ne) ne->conclude();
}

void
ANN::Eval::open()
{
  if (ne) ne->open();
}

ANN::NE::Status
ANN::Eval::close()
{
  return ne ? ne->close() : dumb;
}

